package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProvisioningArtifactName,
  Verbose,
  ProductViewName,
  Id
}
import scala.jdk.CollectionConverters._
final case class DescribeProvisioningArtifactRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    provisioningArtifactId: Optional[Id] = Optional.Absent,
    productId: Optional[Id] = Optional.Absent,
    provisioningArtifactName: Optional[ProvisioningArtifactName] =
      Optional.Absent,
    productName: Optional[ProductViewName] = Optional.Absent,
    verbose: Optional[Verbose] = Optional.Absent,
    includeProvisioningArtifactParameters: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest = {
    import DescribeProvisioningArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        provisioningArtifactName.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.provisioningArtifactName)
      .optionallyWith(
        productName.map(value =>
          ProductViewName.unwrap(value): java.lang.String
        )
      )(_.productName)
      .optionallyWith(
        verbose.map(value => Verbose.unwrap(value): java.lang.Boolean)
      )(_.verbose)
      .optionallyWith(
        includeProvisioningArtifactParameters.map(value =>
          value: java.lang.Boolean
        )
      )(_.includeProvisioningArtifactParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest
      .wrap(buildAwsValue())
}
object DescribeProvisioningArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest =
      zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest(
        acceptLanguage.map(value => value),
        provisioningArtifactId.map(value => value),
        productId.map(value => value),
        provisioningArtifactName.map(value => value),
        productName.map(value => value),
        verbose.map(value => value),
        includeProvisioningArtifactParameters.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def provisioningArtifactId: Optional[Id]
    def productId: Optional[Id]
    def provisioningArtifactName: Optional[ProvisioningArtifactName]
    def productName: Optional[ProductViewName]
    def verbose: Optional[Verbose]
    def includeProvisioningArtifactParameters: Optional[Boolean]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProvisioningArtifactName
        : ZIO[Any, AwsError, ProvisioningArtifactName] = AwsError
      .unwrapOptionField("provisioningArtifactName", provisioningArtifactName)
    def getProductName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("productName", productName)
    def getVerbose: ZIO[Any, AwsError, Verbose] =
      AwsError.unwrapOptionField("verbose", verbose)
    def getIncludeProvisioningArtifactParameters: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "includeProvisioningArtifactParameters",
        includeProvisioningArtifactParameters
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest
  ) extends zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val provisioningArtifactId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactName: Optional[ProvisioningArtifactName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningArtifactName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val productName: Optional[ProductViewName] = zio.aws.core.internal
      .optionalFromNullable(impl.productName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val verbose: Optional[Verbose] = zio.aws.core.internal
      .optionalFromNullable(impl.verbose())
      .map(value => zio.aws.servicecatalog.model.primitives.Verbose(value))
    override val includeProvisioningArtifactParameters: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeProvisioningArtifactParameters())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest
  ): zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
