package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class DescribeProvisionedProductPlanResponse(
    provisionedProductPlanDetails: Optional[
      zio.aws.servicecatalog.model.ProvisionedProductPlanDetails
    ] = Optional.Absent,
    resourceChanges: Optional[
      Iterable[zio.aws.servicecatalog.model.ResourceChange]
    ] = Optional.Absent,
    nextPageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanResponse = {
    import DescribeProvisionedProductPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanResponse
      .builder()
      .optionallyWith(
        provisionedProductPlanDetails.map(value => value.buildAwsValue())
      )(_.provisionedProductPlanDetails)
      .optionallyWith(
        resourceChanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceChanges)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse
      .wrap(buildAwsValue())
}
object DescribeProvisionedProductPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse =
      zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse(
        provisionedProductPlanDetails.map(value => value.asEditable),
        resourceChanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def provisionedProductPlanDetails: Optional[
      zio.aws.servicecatalog.model.ProvisionedProductPlanDetails.ReadOnly
    ]
    def resourceChanges
        : Optional[List[zio.aws.servicecatalog.model.ResourceChange.ReadOnly]]
    def nextPageToken: Optional[PageToken]
    def getProvisionedProductPlanDetails: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductPlanDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedProductPlanDetails",
      provisionedProductPlanDetails
    )
    def getResourceChanges: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ResourceChange.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceChanges", resourceChanges)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanResponse
  ) extends zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse.ReadOnly {
    override val provisionedProductPlanDetails: Optional[
      zio.aws.servicecatalog.model.ProvisionedProductPlanDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedProductPlanDetails())
      .map(value =>
        zio.aws.servicecatalog.model.ProvisionedProductPlanDetails.wrap(value)
      )
    override val resourceChanges
        : Optional[List[zio.aws.servicecatalog.model.ResourceChange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceChanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.ResourceChange.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanResponse
  ): zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse.ReadOnly =
    new Wrapper(impl)
}
