package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.SourceType
  ): zio.aws.servicecatalog.model.SourceType = value match {
    case software.amazon.awssdk.services.servicecatalog.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.SourceType.CODESTAR =>
      val r = CODESTAR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.SourceType =
      software.amazon.awssdk.services.servicecatalog.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object CODESTAR extends zio.aws.servicecatalog.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.SourceType =
      software.amazon.awssdk.services.servicecatalog.model.SourceType.CODESTAR
  }
}
