package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ProductSource {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.ProductSource
}
object ProductSource {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ProductSource
  ): zio.aws.servicecatalog.model.ProductSource = value match {
    case software.amazon.awssdk.services.servicecatalog.model.ProductSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductSource.ACCOUNT =>
      val r = ACCOUNT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ProductSource {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductSource =
      software.amazon.awssdk.services.servicecatalog.model.ProductSource.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT extends zio.aws.servicecatalog.model.ProductSource {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductSource =
      software.amazon.awssdk.services.servicecatalog.model.ProductSource.ACCOUNT
  }
}
