package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListProvisioningArtifactsResponse(
    provisioningArtifactDetails: Optional[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifactDetail]
    ] = Optional.Absent,
    nextPageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsResponse = {
    import ListProvisioningArtifactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsResponse
      .builder()
      .optionallyWith(
        provisioningArtifactDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifactDetails)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListProvisioningArtifactsResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListProvisioningArtifactsResponse
      .wrap(buildAwsValue())
}
object ListProvisioningArtifactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListProvisioningArtifactsResponse =
      zio.aws.servicecatalog.model.ListProvisioningArtifactsResponse(
        provisioningArtifactDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def provisioningArtifactDetails: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly]
    ]
    def nextPageToken: Optional[PageToken]
    def getProvisioningArtifactDetails: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningArtifactDetails",
      provisioningArtifactDetails
    )
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsResponse
  ) extends zio.aws.servicecatalog.model.ListProvisioningArtifactsResponse.ReadOnly {
    override val provisioningArtifactDetails: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifactDetail.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsResponse
  ): zio.aws.servicecatalog.model.ListProvisioningArtifactsResponse.ReadOnly =
    new Wrapper(impl)
}
