package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  PageSizeMax100,
  PageToken,
  Id,
  AcceptLanguage
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPortfolioAccessRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    portfolioId: Id,
    organizationParentId: Optional[Id] = Optional.Absent,
    pageToken: Optional[PageToken] = Optional.Absent,
    pageSize: Optional[PageSizeMax100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest = {
    import ListPortfolioAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .optionallyWith(
        organizationParentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.organizationParentId)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(
        pageSize.map(value => PageSizeMax100.unwrap(value): Integer)
      )(_.pageSize)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListPortfolioAccessRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListPortfolioAccessRequest
      .wrap(buildAwsValue())
}
object ListPortfolioAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListPortfolioAccessRequest =
      zio.aws.servicecatalog.model.ListPortfolioAccessRequest(
        acceptLanguage.map(value => value),
        portfolioId,
        organizationParentId.map(value => value),
        pageToken.map(value => value),
        pageSize.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def portfolioId: Id
    def organizationParentId: Optional[Id]
    def pageToken: Optional[PageToken]
    def pageSize: Optional[PageSizeMax100]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getOrganizationParentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("organizationParentId", organizationParentId)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getPageSize: ZIO[Any, AwsError, PageSizeMax100] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest
  ) extends zio.aws.servicecatalog.model.ListPortfolioAccessRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val organizationParentId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationParentId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val pageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val pageSize: Optional[PageSizeMax100] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PageSizeMax100(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest
  ): zio.aws.servicecatalog.model.ListPortfolioAccessRequest.ReadOnly =
    new Wrapper(impl)
}
