package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait LastSyncStatus {
  def unwrap
      : software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus
}
object LastSyncStatus {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus
  ): zio.aws.servicecatalog.model.LastSyncStatus = value match {
    case software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.LastSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus =
      software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED extends zio.aws.servicecatalog.model.LastSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus =
      software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.servicecatalog.model.LastSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus =
      software.amazon.awssdk.services.servicecatalog.model.LastSyncStatus.FAILED
  }
}
