package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateProductResponse(
    productViewDetail: Optional[
      zio.aws.servicecatalog.model.ProductViewDetail
    ] = Optional.Absent,
    provisioningArtifactDetail: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactDetail
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateProductResponse = {
    import CreateProductResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateProductResponse
      .builder()
      .optionallyWith(productViewDetail.map(value => value.buildAwsValue()))(
        _.productViewDetail
      )
      .optionallyWith(
        provisioningArtifactDetail.map(value => value.buildAwsValue())
      )(_.provisioningArtifactDetail)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.CreateProductResponse.ReadOnly =
    zio.aws.servicecatalog.model.CreateProductResponse.wrap(buildAwsValue())
}
object CreateProductResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateProductResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreateProductResponse =
      zio.aws.servicecatalog.model.CreateProductResponse(
        productViewDetail.map(value => value.asEditable),
        provisioningArtifactDetail.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def productViewDetail
        : Optional[zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly]
    def provisioningArtifactDetail: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly
    ]
    def tags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def getProductViewDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly
    ] = AwsError.unwrapOptionField("productViewDetail", productViewDetail)
    def getProvisioningArtifactDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningArtifactDetail",
      provisioningArtifactDetail
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProductResponse
  ) extends zio.aws.servicecatalog.model.CreateProductResponse.ReadOnly {
    override val productViewDetail
        : Optional[zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productViewDetail())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewDetail.wrap(value)
        )
    override val provisioningArtifactDetail: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactDetail())
      .map(value =>
        zio.aws.servicecatalog.model.ProvisioningArtifactDetail.wrap(value)
      )
    override val tags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProductResponse
  ): zio.aws.servicecatalog.model.CreateProductResponse.ReadOnly = new Wrapper(
    impl
  )
}
