package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProductViewShortDescription,
  SupportUrl,
  SupportDescription,
  ProductViewName,
  SupportEmail,
  ProductViewOwner,
  Id,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class UpdateProductRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    id: Id,
    name: Optional[ProductViewName] = Optional.Absent,
    owner: Optional[ProductViewOwner] = Optional.Absent,
    description: Optional[ProductViewShortDescription] = Optional.Absent,
    distributor: Optional[ProductViewOwner] = Optional.Absent,
    supportDescription: Optional[SupportDescription] = Optional.Absent,
    supportEmail: Optional[SupportEmail] = Optional.Absent,
    supportUrl: Optional[SupportUrl] = Optional.Absent,
    addTags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] =
      Optional.Absent,
    removeTags: Optional[Iterable[TagKey]] = Optional.Absent,
    sourceConnection: Optional[zio.aws.servicecatalog.model.SourceConnection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest = {
    import UpdateProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => ProductViewName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        owner.map(value => ProductViewOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        description.map(value =>
          ProductViewShortDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        distributor.map(value =>
          ProductViewOwner.unwrap(value): java.lang.String
        )
      )(_.distributor)
      .optionallyWith(
        supportDescription.map(value =>
          SupportDescription.unwrap(value): java.lang.String
        )
      )(_.supportDescription)
      .optionallyWith(
        supportEmail.map(value => SupportEmail.unwrap(value): java.lang.String)
      )(_.supportEmail)
      .optionallyWith(
        supportUrl.map(value => SupportUrl.unwrap(value): java.lang.String)
      )(_.supportUrl)
      .optionallyWith(
        addTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addTags)
      .optionallyWith(
        removeTags.map(value =>
          value.map { item =>
            TagKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeTags)
      .optionallyWith(sourceConnection.map(value => value.buildAwsValue()))(
        _.sourceConnection
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.UpdateProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdateProductRequest.wrap(buildAwsValue())
}
object UpdateProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdateProductRequest =
      zio.aws.servicecatalog.model.UpdateProductRequest(
        acceptLanguage.map(value => value),
        id,
        name.map(value => value),
        owner.map(value => value),
        description.map(value => value),
        distributor.map(value => value),
        supportDescription.map(value => value),
        supportEmail.map(value => value),
        supportUrl.map(value => value),
        addTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeTags.map(value => value),
        sourceConnection.map(value => value.asEditable)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def id: Id
    def name: Optional[ProductViewName]
    def owner: Optional[ProductViewOwner]
    def description: Optional[ProductViewShortDescription]
    def distributor: Optional[ProductViewOwner]
    def supportDescription: Optional[SupportDescription]
    def supportEmail: Optional[SupportEmail]
    def supportUrl: Optional[SupportUrl]
    def addTags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def removeTags: Optional[List[TagKey]]
    def sourceConnection
        : Optional[zio.aws.servicecatalog.model.SourceConnection.ReadOnly]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, ProductViewOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getDescription: ZIO[Any, AwsError, ProductViewShortDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDistributor: ZIO[Any, AwsError, ProductViewOwner] =
      AwsError.unwrapOptionField("distributor", distributor)
    def getSupportDescription: ZIO[Any, AwsError, SupportDescription] =
      AwsError.unwrapOptionField("supportDescription", supportDescription)
    def getSupportEmail: ZIO[Any, AwsError, SupportEmail] =
      AwsError.unwrapOptionField("supportEmail", supportEmail)
    def getSupportUrl: ZIO[Any, AwsError, SupportUrl] =
      AwsError.unwrapOptionField("supportUrl", supportUrl)
    def getAddTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("addTags", addTags)
    def getRemoveTags: ZIO[Any, AwsError, List[TagKey]] =
      AwsError.unwrapOptionField("removeTags", removeTags)
    def getSourceConnection: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.SourceConnection.ReadOnly
    ] = AwsError.unwrapOptionField("sourceConnection", sourceConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest
  ) extends zio.aws.servicecatalog.model.UpdateProductRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
    override val name: Optional[ProductViewName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val owner: Optional[ProductViewOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewOwner(value)
      )
    override val description: Optional[ProductViewShortDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProductViewShortDescription(value)
        )
    override val distributor: Optional[ProductViewOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.distributor())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewOwner(value)
      )
    override val supportDescription: Optional[SupportDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportDescription())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.SupportDescription(value)
        )
    override val supportEmail: Optional[SupportEmail] = zio.aws.core.internal
      .optionalFromNullable(impl.supportEmail())
      .map(value => zio.aws.servicecatalog.model.primitives.SupportEmail(value))
    override val supportUrl: Optional[SupportUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.supportUrl())
      .map(value => zio.aws.servicecatalog.model.primitives.SupportUrl(value))
    override val addTags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val removeTags: Optional[List[TagKey]] = zio.aws.core.internal
      .optionalFromNullable(impl.removeTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.TagKey(item)
        }.toList
      )
    override val sourceConnection
        : Optional[zio.aws.servicecatalog.model.SourceConnection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceConnection())
        .map(value => zio.aws.servicecatalog.model.SourceConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest
  ): zio.aws.servicecatalog.model.UpdateProductRequest.ReadOnly = new Wrapper(
    impl
  )
}
