package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  NullableBoolean,
  AccountId,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class UpdatePortfolioShareRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    portfolioId: Id,
    accountId: Optional[AccountId] = Optional.Absent,
    organizationNode: Optional[zio.aws.servicecatalog.model.OrganizationNode] =
      Optional.Absent,
    shareTagOptions: Optional[NullableBoolean] = Optional.Absent,
    sharePrincipals: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareRequest = {
    import UpdatePortfolioShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(organizationNode.map(value => value.buildAwsValue()))(
        _.organizationNode
      )
      .optionallyWith(shareTagOptions.map(value => value: java.lang.Boolean))(
        _.shareTagOptions
      )
      .optionallyWith(sharePrincipals.map(value => value: java.lang.Boolean))(
        _.sharePrincipals
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdatePortfolioShareRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdatePortfolioShareRequest
      .wrap(buildAwsValue())
}
object UpdatePortfolioShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdatePortfolioShareRequest =
      zio.aws.servicecatalog.model.UpdatePortfolioShareRequest(
        acceptLanguage.map(value => value),
        portfolioId,
        accountId.map(value => value),
        organizationNode.map(value => value.asEditable),
        shareTagOptions.map(value => value),
        sharePrincipals.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def portfolioId: Id
    def accountId: Optional[AccountId]
    def organizationNode
        : Optional[zio.aws.servicecatalog.model.OrganizationNode.ReadOnly]
    def shareTagOptions: Optional[NullableBoolean]
    def sharePrincipals: Optional[NullableBoolean]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getOrganizationNode: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.OrganizationNode.ReadOnly
    ] = AwsError.unwrapOptionField("organizationNode", organizationNode)
    def getShareTagOptions: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("shareTagOptions", shareTagOptions)
    def getSharePrincipals: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("sharePrincipals", sharePrincipals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareRequest
  ) extends zio.aws.servicecatalog.model.UpdatePortfolioShareRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.servicecatalog.model.primitives.AccountId(value))
    override val organizationNode
        : Optional[zio.aws.servicecatalog.model.OrganizationNode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationNode())
        .map(value => zio.aws.servicecatalog.model.OrganizationNode.wrap(value))
    override val shareTagOptions: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shareTagOptions())
        .map(value => value: NullableBoolean)
    override val sharePrincipals: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sharePrincipals())
        .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareRequest
  ): zio.aws.servicecatalog.model.UpdatePortfolioShareRequest.ReadOnly =
    new Wrapper(impl)
}
