package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SourceConnectionDetail(
    `type`: Optional[zio.aws.servicecatalog.model.SourceType] = Optional.Absent,
    connectionParameters: Optional[
      zio.aws.servicecatalog.model.SourceConnectionParameters
    ] = Optional.Absent,
    lastSync: Optional[zio.aws.servicecatalog.model.LastSync] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.SourceConnectionDetail = {
    import SourceConnectionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.SourceConnectionDetail
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(connectionParameters.map(value => value.buildAwsValue()))(
        _.connectionParameters
      )
      .optionallyWith(lastSync.map(value => value.buildAwsValue()))(_.lastSync)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.SourceConnectionDetail.ReadOnly =
    zio.aws.servicecatalog.model.SourceConnectionDetail.wrap(buildAwsValue())
}
object SourceConnectionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.SourceConnectionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.SourceConnectionDetail =
      zio.aws.servicecatalog.model.SourceConnectionDetail(
        `type`.map(value => value),
        connectionParameters.map(value => value.asEditable),
        lastSync.map(value => value.asEditable)
      )
    def `type`: Optional[zio.aws.servicecatalog.model.SourceType]
    def connectionParameters: Optional[
      zio.aws.servicecatalog.model.SourceConnectionParameters.ReadOnly
    ]
    def lastSync: Optional[zio.aws.servicecatalog.model.LastSync.ReadOnly]
    def getType: ZIO[Any, AwsError, zio.aws.servicecatalog.model.SourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getConnectionParameters: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.SourceConnectionParameters.ReadOnly
    ] = AwsError.unwrapOptionField("connectionParameters", connectionParameters)
    def getLastSync
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.LastSync.ReadOnly] =
      AwsError.unwrapOptionField("lastSync", lastSync)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.SourceConnectionDetail
  ) extends zio.aws.servicecatalog.model.SourceConnectionDetail.ReadOnly {
    override val `type`: Optional[zio.aws.servicecatalog.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.servicecatalog.model.SourceType.wrap(value))
    override val connectionParameters: Optional[
      zio.aws.servicecatalog.model.SourceConnectionParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionParameters())
      .map(value =>
        zio.aws.servicecatalog.model.SourceConnectionParameters.wrap(value)
      )
    override val lastSync
        : Optional[zio.aws.servicecatalog.model.LastSync.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSync())
        .map(value => zio.aws.servicecatalog.model.LastSync.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.SourceConnectionDetail
  ): zio.aws.servicecatalog.model.SourceConnectionDetail.ReadOnly = new Wrapper(
    impl
  )
}
