package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.CloudWatchDashboardName
import scala.jdk.CollectionConverters._
final case class CloudWatchDashboard(
    name: Optional[CloudWatchDashboardName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CloudWatchDashboard = {
    import CloudWatchDashboard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CloudWatchDashboard
      .builder()
      .optionallyWith(
        name.map(value =>
          CloudWatchDashboardName.unwrap(value): java.lang.String
        )
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.CloudWatchDashboard.ReadOnly =
    zio.aws.servicecatalog.model.CloudWatchDashboard.wrap(buildAwsValue())
}
object CloudWatchDashboard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CloudWatchDashboard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CloudWatchDashboard =
      zio.aws.servicecatalog.model.CloudWatchDashboard(name.map(value => value))
    def name: Optional[CloudWatchDashboardName]
    def getName: ZIO[Any, AwsError, CloudWatchDashboardName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CloudWatchDashboard
  ) extends zio.aws.servicecatalog.model.CloudWatchDashboard.ReadOnly {
    override val name: Optional[CloudWatchDashboardName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.CloudWatchDashboardName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CloudWatchDashboard
  ): zio.aws.servicecatalog.model.CloudWatchDashboard.ReadOnly = new Wrapper(
    impl
  )
}
