package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchAssociateServiceActionWithProvisioningArtifactResponse(
    failedServiceActionAssociations: Optional[
      Iterable[zio.aws.servicecatalog.model.FailedServiceActionAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse = {
    import BatchAssociateServiceActionWithProvisioningArtifactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse
      .builder()
      .optionallyWith(
        failedServiceActionAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedServiceActionAssociations)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse.ReadOnly =
    zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse
      .wrap(buildAwsValue())
}
object BatchAssociateServiceActionWithProvisioningArtifactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse =
      zio.aws.servicecatalog.model
        .BatchAssociateServiceActionWithProvisioningArtifactResponse(
          failedServiceActionAssociations.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def failedServiceActionAssociations: Optional[
      List[zio.aws.servicecatalog.model.FailedServiceActionAssociation.ReadOnly]
    ]
    def getFailedServiceActionAssociations: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.FailedServiceActionAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "failedServiceActionAssociations",
      failedServiceActionAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse
  ) extends zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse.ReadOnly {
    override val failedServiceActionAssociations: Optional[
      List[zio.aws.servicecatalog.model.FailedServiceActionAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedServiceActionAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.FailedServiceActionAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse
  ): zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse.ReadOnly =
    new Wrapper(impl)
}
