package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait AccessLevelFilterKey {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey
}
object AccessLevelFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey
  ): zio.aws.servicecatalog.model.AccessLevelFilterKey = value match {
    case software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey.ACCOUNT =>
      val r = Account
      r
    case software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey.ROLE =>
      val r = Role
      r
    case software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey.USER =>
      val r = User
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.AccessLevelFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey =
      software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Account
      extends zio.aws.servicecatalog.model.AccessLevelFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey =
      software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey.ACCOUNT
  }
  case object Role extends zio.aws.servicecatalog.model.AccessLevelFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey =
      software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey.ROLE
  }
  case object User extends zio.aws.servicecatalog.model.AccessLevelFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey =
      software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilterKey.USER
  }
}
