package zio.aws.servicecatalog
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.servicecatalog.model.primitives.{
  TagOptionValue,
  ProductViewFilterValue,
  ProvisioningArtifactInfoValue,
  ExecutionParameterKey,
  AccountId,
  ProvisioningArtifactPropertyValue,
  NotificationArn,
  ServiceActionDefinitionValue,
  ProvisioningArtifactInfoKey,
  Region,
  ExecutionParameterValue,
  PropertyValue,
  ProvisionedProductViewFilterValue,
  OutputKey,
  ProductViewAggregationType,
  TagKey
}
import zio.aws.servicecatalog.model.primitives.OrganizationNodeValue.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AcceptLanguage extends Subtype[String]
    type AcceptLanguage =
      zio.aws.servicecatalog.model.primitives.AcceptLanguage.Type
    object AccessLevelFilterValue extends Subtype[String]
    type AccessLevelFilterValue =
      zio.aws.servicecatalog.model.primitives.AccessLevelFilterValue.Type
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.servicecatalog.model.primitives.AccountId.Type
    object ApproximateCount extends Subtype[Int]
    type ApproximateCount =
      zio.aws.servicecatalog.model.primitives.ApproximateCount.Type
    object AttributeValue extends Subtype[String]
    type AttributeValue =
      zio.aws.servicecatalog.model.primitives.AttributeValue.Type
    object BudgetName extends Subtype[String]
    type BudgetName = zio.aws.servicecatalog.model.primitives.BudgetName.Type
    object CausingEntity extends Subtype[String]
    type CausingEntity =
      zio.aws.servicecatalog.model.primitives.CausingEntity.Type
    object CloudWatchDashboardName extends Subtype[String]
    type CloudWatchDashboardName =
      zio.aws.servicecatalog.model.primitives.CloudWatchDashboardName.Type
    object CodeStarConnectionArn extends Subtype[String]
    type CodeStarConnectionArn =
      zio.aws.servicecatalog.model.primitives.CodeStarConnectionArn.Type
    object ConstraintDescription extends Subtype[String]
    type ConstraintDescription =
      zio.aws.servicecatalog.model.primitives.ConstraintDescription.Type
    object ConstraintParameters extends Subtype[String]
    type ConstraintParameters =
      zio.aws.servicecatalog.model.primitives.ConstraintParameters.Type
    object ConstraintType extends Subtype[String]
    type ConstraintType =
      zio.aws.servicecatalog.model.primitives.ConstraintType.Type
    object CreatedTime extends Subtype[Instant]
    type CreatedTime = zio.aws.servicecatalog.model.primitives.CreatedTime.Type
    object CreationTime extends Subtype[Instant]
    type CreationTime =
      zio.aws.servicecatalog.model.primitives.CreationTime.Type
    object DefaultValue extends Subtype[String]
    type DefaultValue =
      zio.aws.servicecatalog.model.primitives.DefaultValue.Type
    object Description extends Subtype[String]
    type Description = zio.aws.servicecatalog.model.primitives.Description.Type
    object DisableTemplateValidation extends Subtype[Boolean]
    type DisableTemplateValidation =
      zio.aws.servicecatalog.model.primitives.DisableTemplateValidation.Type
    object Error extends Subtype[String]
    type Error = zio.aws.servicecatalog.model.primitives.Error.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.servicecatalog.model.primitives.ErrorCode.Type
    object ErrorDescription extends Subtype[String]
    type ErrorDescription =
      zio.aws.servicecatalog.model.primitives.ErrorDescription.Type
    object ExecutionParameterKey extends Subtype[String]
    type ExecutionParameterKey =
      zio.aws.servicecatalog.model.primitives.ExecutionParameterKey.Type
    object ExecutionParameterType extends Subtype[String]
    type ExecutionParameterType =
      zio.aws.servicecatalog.model.primitives.ExecutionParameterType.Type
    object ExecutionParameterValue extends Subtype[String]
    type ExecutionParameterValue =
      zio.aws.servicecatalog.model.primitives.ExecutionParameterValue.Type
    object HasDefaultPath extends Subtype[Boolean]
    type HasDefaultPath =
      zio.aws.servicecatalog.model.primitives.HasDefaultPath.Type
    object Id extends Subtype[String]
    type Id = zio.aws.servicecatalog.model.primitives.Id.Type
    object IdempotencyToken extends Subtype[String]
    type IdempotencyToken =
      zio.aws.servicecatalog.model.primitives.IdempotencyToken.Type
    object IgnoreErrors extends Subtype[Boolean]
    type IgnoreErrors =
      zio.aws.servicecatalog.model.primitives.IgnoreErrors.Type
    object InstructionType extends Subtype[String]
    type InstructionType =
      zio.aws.servicecatalog.model.primitives.InstructionType.Type
    object InstructionValue extends Subtype[String]
    type InstructionValue =
      zio.aws.servicecatalog.model.primitives.InstructionValue.Type
    object LastRequestId extends Subtype[String]
    type LastRequestId =
      zio.aws.servicecatalog.model.primitives.LastRequestId.Type
    object LastSuccessfulSyncTime extends Subtype[Instant]
    type LastSuccessfulSyncTime =
      zio.aws.servicecatalog.model.primitives.LastSuccessfulSyncTime.Type
    object LastSyncStatusMessage extends Subtype[String]
    type LastSyncStatusMessage =
      zio.aws.servicecatalog.model.primitives.LastSyncStatusMessage.Type
    object LastSyncTime extends Subtype[Instant]
    type LastSyncTime =
      zio.aws.servicecatalog.model.primitives.LastSyncTime.Type
    object LogicalResourceId extends Subtype[String]
    type LogicalResourceId =
      zio.aws.servicecatalog.model.primitives.LogicalResourceId.Type
    object Message extends Subtype[String]
    type Message = zio.aws.servicecatalog.model.primitives.Message.Type
    object NoEcho extends Subtype[Boolean]
    type NoEcho = zio.aws.servicecatalog.model.primitives.NoEcho.Type
    object NotificationArn extends Subtype[String]
    type NotificationArn =
      zio.aws.servicecatalog.model.primitives.NotificationArn.Type
    type NullableBoolean = Boolean
    object OrganizationNodeValue extends Subtype[String]
    type OrganizationNodeValue =
      zio.aws.servicecatalog.model.primitives.OrganizationNodeValue.Type
    object OutputDescription extends Subtype[String]
    type OutputDescription =
      zio.aws.servicecatalog.model.primitives.OutputDescription.Type
    object OutputKey extends Subtype[String]
    type OutputKey = zio.aws.servicecatalog.model.primitives.OutputKey.Type
    object OutputValue extends Subtype[String]
    type OutputValue = zio.aws.servicecatalog.model.primitives.OutputValue.Type
    object Owner extends Subtype[String]
    type Owner = zio.aws.servicecatalog.model.primitives.Owner.Type
    object PageSize extends Subtype[Int]
    type PageSize = zio.aws.servicecatalog.model.primitives.PageSize.Type
    object PageSizeMax100 extends Subtype[Int]
    type PageSizeMax100 =
      zio.aws.servicecatalog.model.primitives.PageSizeMax100.Type
    object PageToken extends Subtype[String]
    type PageToken = zio.aws.servicecatalog.model.primitives.PageToken.Type
    object ParameterKey extends Subtype[String]
    type ParameterKey =
      zio.aws.servicecatalog.model.primitives.ParameterKey.Type
    object ParameterType extends Subtype[String]
    type ParameterType =
      zio.aws.servicecatalog.model.primitives.ParameterType.Type
    object ParameterValue extends Subtype[String]
    type ParameterValue =
      zio.aws.servicecatalog.model.primitives.ParameterValue.Type
    object PhysicalId extends Subtype[String]
    type PhysicalId = zio.aws.servicecatalog.model.primitives.PhysicalId.Type
    object PhysicalResourceId extends Subtype[String]
    type PhysicalResourceId =
      zio.aws.servicecatalog.model.primitives.PhysicalResourceId.Type
    object PlanResourceType extends Subtype[String]
    type PlanResourceType =
      zio.aws.servicecatalog.model.primitives.PlanResourceType.Type
    object PortfolioDescription extends Subtype[String]
    type PortfolioDescription =
      zio.aws.servicecatalog.model.primitives.PortfolioDescription.Type
    object PortfolioDisplayName extends Subtype[String]
    type PortfolioDisplayName =
      zio.aws.servicecatalog.model.primitives.PortfolioDisplayName.Type
    object PortfolioName extends Subtype[String]
    type PortfolioName =
      zio.aws.servicecatalog.model.primitives.PortfolioName.Type
    object PrincipalARN extends Subtype[String]
    type PrincipalARN =
      zio.aws.servicecatalog.model.primitives.PrincipalARN.Type
    object ProductArn extends Subtype[String]
    type ProductArn = zio.aws.servicecatalog.model.primitives.ProductArn.Type
    object ProductViewAggregationType extends Subtype[String]
    type ProductViewAggregationType =
      zio.aws.servicecatalog.model.primitives.ProductViewAggregationType.Type
    object ProductViewDistributor extends Subtype[String]
    type ProductViewDistributor =
      zio.aws.servicecatalog.model.primitives.ProductViewDistributor.Type
    object ProductViewFilterValue extends Subtype[String]
    type ProductViewFilterValue =
      zio.aws.servicecatalog.model.primitives.ProductViewFilterValue.Type
    object ProductViewName extends Subtype[String]
    type ProductViewName =
      zio.aws.servicecatalog.model.primitives.ProductViewName.Type
    object ProductViewOwner extends Subtype[String]
    type ProductViewOwner =
      zio.aws.servicecatalog.model.primitives.ProductViewOwner.Type
    object ProductViewShortDescription extends Subtype[String]
    type ProductViewShortDescription =
      zio.aws.servicecatalog.model.primitives.ProductViewShortDescription.Type
    object PropertyName extends Subtype[String]
    type PropertyName =
      zio.aws.servicecatalog.model.primitives.PropertyName.Type
    object PropertyValue extends Subtype[String]
    type PropertyValue =
      zio.aws.servicecatalog.model.primitives.PropertyValue.Type
    object ProviderName extends Subtype[String]
    type ProviderName =
      zio.aws.servicecatalog.model.primitives.ProviderName.Type
    object ProvisionedProductId extends Subtype[String]
    type ProvisionedProductId =
      zio.aws.servicecatalog.model.primitives.ProvisionedProductId.Type
    object ProvisionedProductName extends Subtype[String]
    type ProvisionedProductName =
      zio.aws.servicecatalog.model.primitives.ProvisionedProductName.Type
    object ProvisionedProductNameOrArn extends Subtype[String]
    type ProvisionedProductNameOrArn =
      zio.aws.servicecatalog.model.primitives.ProvisionedProductNameOrArn.Type
    object ProvisionedProductPlanName extends Subtype[String]
    type ProvisionedProductPlanName =
      zio.aws.servicecatalog.model.primitives.ProvisionedProductPlanName.Type
    object ProvisionedProductStatusMessage extends Subtype[String]
    type ProvisionedProductStatusMessage =
      zio.aws.servicecatalog.model.primitives.ProvisionedProductStatusMessage.Type
    object ProvisionedProductType extends Subtype[String]
    type ProvisionedProductType =
      zio.aws.servicecatalog.model.primitives.ProvisionedProductType.Type
    object ProvisionedProductViewFilterValue extends Subtype[String]
    type ProvisionedProductViewFilterValue =
      zio.aws.servicecatalog.model.primitives.ProvisionedProductViewFilterValue.Type
    object ProvisioningArtifactActive extends Subtype[Boolean]
    type ProvisioningArtifactActive =
      zio.aws.servicecatalog.model.primitives.ProvisioningArtifactActive.Type
    object ProvisioningArtifactCreatedTime extends Subtype[Instant]
    type ProvisioningArtifactCreatedTime =
      zio.aws.servicecatalog.model.primitives.ProvisioningArtifactCreatedTime.Type
    object ProvisioningArtifactDescription extends Subtype[String]
    type ProvisioningArtifactDescription =
      zio.aws.servicecatalog.model.primitives.ProvisioningArtifactDescription.Type
    object ProvisioningArtifactInfoKey extends Subtype[String]
    type ProvisioningArtifactInfoKey =
      zio.aws.servicecatalog.model.primitives.ProvisioningArtifactInfoKey.Type
    object ProvisioningArtifactInfoValue extends Subtype[String]
    type ProvisioningArtifactInfoValue =
      zio.aws.servicecatalog.model.primitives.ProvisioningArtifactInfoValue.Type
    object ProvisioningArtifactName extends Subtype[String]
    type ProvisioningArtifactName =
      zio.aws.servicecatalog.model.primitives.ProvisioningArtifactName.Type
    object ProvisioningArtifactOutputKey extends Subtype[String]
    type ProvisioningArtifactOutputKey =
      zio.aws.servicecatalog.model.primitives.ProvisioningArtifactOutputKey.Type
    object ProvisioningArtifactPropertyValue extends Subtype[String]
    type ProvisioningArtifactPropertyValue =
      zio.aws.servicecatalog.model.primitives.ProvisioningArtifactPropertyValue.Type
    object RecordTagKey extends Subtype[String]
    type RecordTagKey =
      zio.aws.servicecatalog.model.primitives.RecordTagKey.Type
    object RecordTagValue extends Subtype[String]
    type RecordTagValue =
      zio.aws.servicecatalog.model.primitives.RecordTagValue.Type
    object RecordType extends Subtype[String]
    type RecordType = zio.aws.servicecatalog.model.primitives.RecordType.Type
    object Region extends Subtype[String]
    type Region = zio.aws.servicecatalog.model.primitives.Region.Type
    object Repository extends Subtype[String]
    type Repository = zio.aws.servicecatalog.model.primitives.Repository.Type
    object RepositoryArtifactPath extends Subtype[String]
    type RepositoryArtifactPath =
      zio.aws.servicecatalog.model.primitives.RepositoryArtifactPath.Type
    object RepositoryBranch extends Subtype[String]
    type RepositoryBranch =
      zio.aws.servicecatalog.model.primitives.RepositoryBranch.Type
    object ResourceARN extends Subtype[String]
    type ResourceARN = zio.aws.servicecatalog.model.primitives.ResourceARN.Type
    object ResourceDetailARN extends Subtype[String]
    type ResourceDetailARN =
      zio.aws.servicecatalog.model.primitives.ResourceDetailARN.Type
    object ResourceDetailCreatedTime extends Subtype[Instant]
    type ResourceDetailCreatedTime =
      zio.aws.servicecatalog.model.primitives.ResourceDetailCreatedTime.Type
    object ResourceDetailDescription extends Subtype[String]
    type ResourceDetailDescription =
      zio.aws.servicecatalog.model.primitives.ResourceDetailDescription.Type
    object ResourceDetailId extends Subtype[String]
    type ResourceDetailId =
      zio.aws.servicecatalog.model.primitives.ResourceDetailId.Type
    object ResourceDetailName extends Subtype[String]
    type ResourceDetailName =
      zio.aws.servicecatalog.model.primitives.ResourceDetailName.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.servicecatalog.model.primitives.ResourceId.Type
    object ResourceType extends Subtype[String]
    type ResourceType =
      zio.aws.servicecatalog.model.primitives.ResourceType.Type
    object RetainPhysicalResources extends Subtype[Boolean]
    type RetainPhysicalResources =
      zio.aws.servicecatalog.model.primitives.RetainPhysicalResources.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.servicecatalog.model.primitives.RoleArn.Type
    object SearchFilterKey extends Subtype[String]
    type SearchFilterKey =
      zio.aws.servicecatalog.model.primitives.SearchFilterKey.Type
    object SearchFilterValue extends Subtype[String]
    type SearchFilterValue =
      zio.aws.servicecatalog.model.primitives.SearchFilterValue.Type
    object SearchProvisionedProductsPageSize extends Subtype[Int]
    type SearchProvisionedProductsPageSize =
      zio.aws.servicecatalog.model.primitives.SearchProvisionedProductsPageSize.Type
    object ServiceActionAssociationErrorMessage extends Subtype[String]
    type ServiceActionAssociationErrorMessage =
      zio.aws.servicecatalog.model.primitives.ServiceActionAssociationErrorMessage.Type
    object ServiceActionDefinitionValue extends Subtype[String]
    type ServiceActionDefinitionValue =
      zio.aws.servicecatalog.model.primitives.ServiceActionDefinitionValue.Type
    object ServiceActionDescription extends Subtype[String]
    type ServiceActionDescription =
      zio.aws.servicecatalog.model.primitives.ServiceActionDescription.Type
    object ServiceActionName extends Subtype[String]
    type ServiceActionName =
      zio.aws.servicecatalog.model.primitives.ServiceActionName.Type
    object SortField extends Subtype[String]
    type SortField = zio.aws.servicecatalog.model.primitives.SortField.Type
    object SourceRevision extends Subtype[String]
    type SourceRevision =
      zio.aws.servicecatalog.model.primitives.SourceRevision.Type
    object StackSetFailureToleranceCount extends Subtype[Int]
    type StackSetFailureToleranceCount =
      zio.aws.servicecatalog.model.primitives.StackSetFailureToleranceCount.Type
    object StackSetFailureTolerancePercentage extends Subtype[Int]
    type StackSetFailureTolerancePercentage =
      zio.aws.servicecatalog.model.primitives.StackSetFailureTolerancePercentage.Type
    object StackSetMaxConcurrencyCount extends Subtype[Int]
    type StackSetMaxConcurrencyCount =
      zio.aws.servicecatalog.model.primitives.StackSetMaxConcurrencyCount.Type
    object StackSetMaxConcurrencyPercentage extends Subtype[Int]
    type StackSetMaxConcurrencyPercentage =
      zio.aws.servicecatalog.model.primitives.StackSetMaxConcurrencyPercentage.Type
    object StatusDetail extends Subtype[String]
    type StatusDetail =
      zio.aws.servicecatalog.model.primitives.StatusDetail.Type
    object StatusMessage extends Subtype[String]
    type StatusMessage =
      zio.aws.servicecatalog.model.primitives.StatusMessage.Type
    object SupportDescription extends Subtype[String]
    type SupportDescription =
      zio.aws.servicecatalog.model.primitives.SupportDescription.Type
    object SupportEmail extends Subtype[String]
    type SupportEmail =
      zio.aws.servicecatalog.model.primitives.SupportEmail.Type
    object SupportUrl extends Subtype[String]
    type SupportUrl = zio.aws.servicecatalog.model.primitives.SupportUrl.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.servicecatalog.model.primitives.TagKey.Type
    object TagOptionActive extends Subtype[Boolean]
    type TagOptionActive =
      zio.aws.servicecatalog.model.primitives.TagOptionActive.Type
    object TagOptionId extends Subtype[String]
    type TagOptionId = zio.aws.servicecatalog.model.primitives.TagOptionId.Type
    object TagOptionKey extends Subtype[String]
    type TagOptionKey =
      zio.aws.servicecatalog.model.primitives.TagOptionKey.Type
    object TagOptionValue extends Subtype[String]
    type TagOptionValue =
      zio.aws.servicecatalog.model.primitives.TagOptionValue.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.servicecatalog.model.primitives.TagValue.Type
    object TotalResultsCount extends Subtype[Int]
    type TotalResultsCount =
      zio.aws.servicecatalog.model.primitives.TotalResultsCount.Type
    object UpdatedTime extends Subtype[Instant]
    type UpdatedTime = zio.aws.servicecatalog.model.primitives.UpdatedTime.Type
    object UsePreviousValue extends Subtype[Boolean]
    type UsePreviousValue =
      zio.aws.servicecatalog.model.primitives.UsePreviousValue.Type
    object UserArn extends Subtype[String]
    type UserArn = zio.aws.servicecatalog.model.primitives.UserArn.Type
    object UserArnSession extends Subtype[String]
    type UserArnSession =
      zio.aws.servicecatalog.model.primitives.UserArnSession.Type
    object Verbose extends Subtype[Boolean]
    type Verbose = zio.aws.servicecatalog.model.primitives.Verbose.Type
  }
  type AccountIds = List[AccountId]
  type AddTags = List[zio.aws.servicecatalog.model.Tag]
  type AllowedValues = List[String]
  type Budgets = List[zio.aws.servicecatalog.model.BudgetDetail]
  type CloudWatchDashboards =
    List[zio.aws.servicecatalog.model.CloudWatchDashboard]
  type ConstraintDetails = List[zio.aws.servicecatalog.model.ConstraintDetail]
  type ConstraintSummaries =
    List[zio.aws.servicecatalog.model.ConstraintSummary]
  type CopyOptions = List[zio.aws.servicecatalog.model.CopyOption]
  type ExecutionParameterMap =
    Map[ExecutionParameterKey, Iterable[ExecutionParameterValue]]
  type ExecutionParameterValueList = List[ExecutionParameterValue]
  type ExecutionParameters =
    List[zio.aws.servicecatalog.model.ExecutionParameter]
  type FailedServiceActionAssociations =
    List[zio.aws.servicecatalog.model.FailedServiceActionAssociation]
  type LaunchPathSummaries =
    List[zio.aws.servicecatalog.model.LaunchPathSummary]
  type LaunchPaths = List[zio.aws.servicecatalog.model.LaunchPath]
  type Namespaces = List[AccountId]
  type NotificationArns = List[NotificationArn]
  type OrganizationNodes = List[zio.aws.servicecatalog.model.OrganizationNode]
  type OutputKeys = List[OutputKey]
  type PortfolioDetails = List[zio.aws.servicecatalog.model.PortfolioDetail]
  type PortfolioShareDetails =
    List[zio.aws.servicecatalog.model.PortfolioShareDetail]
  type Principals = List[zio.aws.servicecatalog.model.Principal]
  type ProductViewAggregationValues =
    List[zio.aws.servicecatalog.model.ProductViewAggregationValue]
  type ProductViewAggregations = Map[ProductViewAggregationType, Iterable[
    zio.aws.servicecatalog.model.ProductViewAggregationValue
  ]]
  type ProductViewDetails = List[zio.aws.servicecatalog.model.ProductViewDetail]
  type ProductViewFilterValues = List[ProductViewFilterValue]
  type ProductViewFilters =
    Map[zio.aws.servicecatalog.model.ProductViewFilterBy, Iterable[
      ProductViewFilterValue
    ]]
  type ProductViewSummaries =
    List[zio.aws.servicecatalog.model.ProductViewSummary]
  type ProvisionedProductAttributes =
    List[zio.aws.servicecatalog.model.ProvisionedProductAttribute]
  type ProvisionedProductDetails =
    List[zio.aws.servicecatalog.model.ProvisionedProductDetail]
  type ProvisionedProductFilters =
    Map[zio.aws.servicecatalog.model.ProvisionedProductViewFilterBy, Iterable[
      ProvisionedProductViewFilterValue
    ]]
  type ProvisionedProductPlans =
    List[zio.aws.servicecatalog.model.ProvisionedProductPlanSummary]
  type ProvisionedProductProperties =
    Map[zio.aws.servicecatalog.model.PropertyKey, PropertyValue]
  type ProvisionedProductViewFilterValues =
    List[ProvisionedProductViewFilterValue]
  type ProvisioningArtifactDetails =
    List[zio.aws.servicecatalog.model.ProvisioningArtifactDetail]
  type ProvisioningArtifactInfo =
    Map[ProvisioningArtifactInfoKey, ProvisioningArtifactInfoValue]
  type ProvisioningArtifactOutputs =
    List[zio.aws.servicecatalog.model.ProvisioningArtifactOutput]
  type ProvisioningArtifactParameters =
    List[zio.aws.servicecatalog.model.ProvisioningArtifactParameter]
  type ProvisioningArtifactSummaries =
    List[zio.aws.servicecatalog.model.ProvisioningArtifactSummary]
  type ProvisioningArtifactViews =
    List[zio.aws.servicecatalog.model.ProvisioningArtifactView]
  type ProvisioningArtifacts =
    List[zio.aws.servicecatalog.model.ProvisioningArtifact]
  type ProvisioningParameters =
    List[zio.aws.servicecatalog.model.ProvisioningParameter]
  type RecordDetails = List[zio.aws.servicecatalog.model.RecordDetail]
  type RecordErrors = List[zio.aws.servicecatalog.model.RecordError]
  type RecordOutputs = List[zio.aws.servicecatalog.model.RecordOutput]
  type RecordTags = List[zio.aws.servicecatalog.model.RecordTag]
  type ResourceChangeDetails =
    List[zio.aws.servicecatalog.model.ResourceChangeDetail]
  type ResourceChanges = List[zio.aws.servicecatalog.model.ResourceChange]
  type ResourceDetails = List[zio.aws.servicecatalog.model.ResourceDetail]
  type Scope = List[zio.aws.servicecatalog.model.ResourceAttribute]
  type ServiceActionAssociations =
    List[zio.aws.servicecatalog.model.ServiceActionAssociation]
  type ServiceActionDefinitionMap = Map[
    zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
    ServiceActionDefinitionValue
  ]
  type ServiceActionSummaries =
    List[zio.aws.servicecatalog.model.ServiceActionSummary]
  type ShareErrors = List[zio.aws.servicecatalog.model.ShareError]
  type SourceProvisioningArtifactProperties = List[Map[
    zio.aws.servicecatalog.model.ProvisioningArtifactPropertyName,
    ProvisioningArtifactPropertyValue
  ]]
  type SourceProvisioningArtifactPropertiesMap = Map[
    zio.aws.servicecatalog.model.ProvisioningArtifactPropertyName,
    ProvisioningArtifactPropertyValue
  ]
  type StackInstances = List[zio.aws.servicecatalog.model.StackInstance]
  type StackSetAccounts = List[AccountId]
  type StackSetRegions = List[Region]
  type SuccessfulShares = List[AccountId]
  type TagKeys = List[TagKey]
  type TagOptionDetails = List[zio.aws.servicecatalog.model.TagOptionDetail]
  type TagOptionSummaries = List[zio.aws.servicecatalog.model.TagOptionSummary]
  type TagOptionValues = List[TagOptionValue]
  type Tags = List[zio.aws.servicecatalog.model.Tag]
  type UpdateProvisioningParameters =
    List[zio.aws.servicecatalog.model.UpdateProvisioningParameter]
  type UsageInstructions = List[zio.aws.servicecatalog.model.UsageInstruction]
}
