package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  TagOptionActive,
  TagOptionValue,
  TagOptionId
}
import scala.jdk.CollectionConverters._
final case class UpdateTagOptionRequest(
    id: TagOptionId,
    value: Optional[TagOptionValue] = Optional.Absent,
    active: Optional[TagOptionActive] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionRequest = {
    import UpdateTagOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionRequest
      .builder()
      .id(TagOptionId.unwrap(id): java.lang.String)
      .optionallyWith(
        value.map(value => TagOptionValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        active.map(value => TagOptionActive.unwrap(value): java.lang.Boolean)
      )(_.active)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.UpdateTagOptionRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdateTagOptionRequest.wrap(buildAwsValue())
}
object UpdateTagOptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdateTagOptionRequest =
      zio.aws.servicecatalog.model.UpdateTagOptionRequest(
        id,
        value.map(value => value),
        active.map(value => value)
      )
    def id: TagOptionId
    def value: Optional[TagOptionValue]
    def active: Optional[TagOptionActive]
    def getId: ZIO[Any, Nothing, TagOptionId] = ZIO.succeed(id)
    def getValue: ZIO[Any, AwsError, TagOptionValue] =
      AwsError.unwrapOptionField("value", value)
    def getActive: ZIO[Any, AwsError, TagOptionActive] =
      AwsError.unwrapOptionField("active", active)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionRequest
  ) extends zio.aws.servicecatalog.model.UpdateTagOptionRequest.ReadOnly {
    override val id: TagOptionId =
      zio.aws.servicecatalog.model.primitives.TagOptionId(impl.id())
    override val value: Optional[TagOptionValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.TagOptionValue(value)
      )
    override val active: Optional[TagOptionActive] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.TagOptionActive(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionRequest
  ): zio.aws.servicecatalog.model.UpdateTagOptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
