package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{PageToken, TotalResultsCount}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchProvisionedProductsResponse(
    provisionedProducts: Optional[
      Iterable[zio.aws.servicecatalog.model.ProvisionedProductAttribute]
    ] = Optional.Absent,
    totalResultsCount: Optional[TotalResultsCount] = Optional.Absent,
    nextPageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse = {
    import SearchProvisionedProductsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse
      .builder()
      .optionallyWith(
        provisionedProducts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedProducts)
      .optionallyWith(
        totalResultsCount.map(value => TotalResultsCount.unwrap(value): Integer)
      )(_.totalResultsCount)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.ReadOnly =
    zio.aws.servicecatalog.model.SearchProvisionedProductsResponse
      .wrap(buildAwsValue())
}
object SearchProvisionedProductsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.SearchProvisionedProductsResponse =
      zio.aws.servicecatalog.model.SearchProvisionedProductsResponse(
        provisionedProducts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalResultsCount.map(value => value),
        nextPageToken.map(value => value)
      )
    def provisionedProducts: Optional[
      List[zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly]
    ]
    def totalResultsCount: Optional[TotalResultsCount]
    def nextPageToken: Optional[PageToken]
    def getProvisionedProducts: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("provisionedProducts", provisionedProducts)
    def getTotalResultsCount: ZIO[Any, AwsError, TotalResultsCount] =
      AwsError.unwrapOptionField("totalResultsCount", totalResultsCount)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse
  ) extends zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.ReadOnly {
    override val provisionedProducts: Optional[
      List[zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedProducts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisionedProductAttribute.wrap(item)
        }.toList
      )
    override val totalResultsCount: Optional[TotalResultsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalResultsCount())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.TotalResultsCount(value)
        )
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse
  ): zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.ReadOnly =
    new Wrapper(impl)
}
