package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  OutputDescription,
  ProvisioningArtifactOutputKey
}
import scala.jdk.CollectionConverters._
final case class ProvisioningArtifactOutput(
    key: Optional[ProvisioningArtifactOutputKey] = Optional.Absent,
    description: Optional[OutputDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput = {
    import ProvisioningArtifactOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput
      .builder()
      .optionallyWith(
        key.map(value =>
          ProvisioningArtifactOutputKey.unwrap(value): java.lang.String
        )
      )(_.key)
      .optionallyWith(
        description.map(value =>
          OutputDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningArtifactOutput
      .wrap(buildAwsValue())
}
object ProvisioningArtifactOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningArtifactOutput =
      zio.aws.servicecatalog.model.ProvisioningArtifactOutput(
        key.map(value => value),
        description.map(value => value)
      )
    def key: Optional[ProvisioningArtifactOutputKey]
    def description: Optional[OutputDescription]
    def getKey: ZIO[Any, AwsError, ProvisioningArtifactOutputKey] =
      AwsError.unwrapOptionField("key", key)
    def getDescription: ZIO[Any, AwsError, OutputDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput
  ) extends zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly {
    override val key: Optional[ProvisioningArtifactOutputKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.key())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactOutputKey(value)
        )
    override val description: Optional[OutputDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.OutputDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput
  ): zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly =
    new Wrapper(impl)
}
