package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  PrincipalARN,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class DisassociatePrincipalFromPortfolioRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    portfolioId: Id,
    principalARN: PrincipalARN,
    principalType: Optional[zio.aws.servicecatalog.model.PrincipalType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest = {
    import DisassociatePrincipalFromPortfolioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .principalARN(PrincipalARN.unwrap(principalARN): java.lang.String)
      .optionallyWith(principalType.map(value => value.unwrap))(_.principalType)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest.ReadOnly =
    zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest
      .wrap(buildAwsValue())
}
object DisassociatePrincipalFromPortfolioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest =
      zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest(
        acceptLanguage.map(value => value),
        portfolioId,
        principalARN,
        principalType.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def portfolioId: Id
    def principalARN: PrincipalARN
    def principalType: Optional[zio.aws.servicecatalog.model.PrincipalType]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getPrincipalARN: ZIO[Any, Nothing, PrincipalARN] =
      ZIO.succeed(principalARN)
    def getPrincipalType
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.PrincipalType] =
      AwsError.unwrapOptionField("principalType", principalType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest
  ) extends zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val principalARN: PrincipalARN =
      zio.aws.servicecatalog.model.primitives.PrincipalARN(impl.principalARN())
    override val principalType
        : Optional[zio.aws.servicecatalog.model.PrincipalType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalType())
        .map(value => zio.aws.servicecatalog.model.PrincipalType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest
  ): zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest.ReadOnly =
    new Wrapper(impl)
}
