package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{AcceptLanguage, Id}
import scala.jdk.CollectionConverters._
final case class DescribeServiceActionExecutionParametersRequest(
    provisionedProductId: Id,
    serviceActionId: Id,
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest = {
    import DescribeServiceActionExecutionParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest
      .builder()
      .provisionedProductId(Id.unwrap(provisionedProductId): java.lang.String)
      .serviceActionId(Id.unwrap(serviceActionId): java.lang.String)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersRequest
      .wrap(buildAwsValue())
}
object DescribeServiceActionExecutionParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersRequest =
      zio.aws.servicecatalog.model
        .DescribeServiceActionExecutionParametersRequest(
          provisionedProductId,
          serviceActionId,
          acceptLanguage.map(value => value)
        )
    def provisionedProductId: Id
    def serviceActionId: Id
    def acceptLanguage: Optional[AcceptLanguage]
    def getProvisionedProductId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisionedProductId)
    def getServiceActionId: ZIO[Any, Nothing, Id] = ZIO.succeed(serviceActionId)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest
  ) extends zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersRequest.ReadOnly {
    override val provisionedProductId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisionedProductId())
    override val serviceActionId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.serviceActionId())
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest
  ): zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersRequest.ReadOnly =
    new Wrapper(impl)
}
