package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeProductResponse(
    productViewSummary: Optional[
      zio.aws.servicecatalog.model.ProductViewSummary
    ] = Optional.Absent,
    provisioningArtifacts: Optional[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifact]
    ] = Optional.Absent,
    budgets: Optional[Iterable[zio.aws.servicecatalog.model.BudgetDetail]] =
      Optional.Absent,
    launchPaths: Optional[Iterable[zio.aws.servicecatalog.model.LaunchPath]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProductResponse = {
    import DescribeProductResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductResponse
      .builder()
      .optionallyWith(productViewSummary.map(value => value.buildAwsValue()))(
        _.productViewSummary
      )
      .optionallyWith(
        provisioningArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifacts)
      .optionallyWith(
        budgets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.budgets)
      .optionallyWith(
        launchPaths.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchPaths)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProductResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProductResponse.wrap(buildAwsValue())
}
object DescribeProductResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribeProductResponse =
      zio.aws.servicecatalog.model.DescribeProductResponse(
        productViewSummary.map(value => value.asEditable),
        provisioningArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        budgets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchPaths.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def productViewSummary
        : Optional[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly]
    def provisioningArtifacts: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly]
    ]
    def budgets
        : Optional[List[zio.aws.servicecatalog.model.BudgetDetail.ReadOnly]]
    def launchPaths
        : Optional[List[zio.aws.servicecatalog.model.LaunchPath.ReadOnly]]
    def getProductViewSummary: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly
    ] = AwsError.unwrapOptionField("productViewSummary", productViewSummary)
    def getProvisioningArtifacts: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly
    ]] =
      AwsError.unwrapOptionField("provisioningArtifacts", provisioningArtifacts)
    def getBudgets: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.BudgetDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("budgets", budgets)
    def getLaunchPaths: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.LaunchPath.ReadOnly
    ]] = AwsError.unwrapOptionField("launchPaths", launchPaths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductResponse
  ) extends zio.aws.servicecatalog.model.DescribeProductResponse.ReadOnly {
    override val productViewSummary
        : Optional[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productViewSummary())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewSummary.wrap(value)
        )
    override val provisioningArtifacts: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifact.wrap(item)
        }.toList
      )
    override val budgets
        : Optional[List[zio.aws.servicecatalog.model.BudgetDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.budgets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.BudgetDetail.wrap(item)
          }.toList
        )
    override val launchPaths
        : Optional[List[zio.aws.servicecatalog.model.LaunchPath.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchPaths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.LaunchPath.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductResponse
  ): zio.aws.servicecatalog.model.DescribeProductResponse.ReadOnly =
    new Wrapper(impl)
}
