package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.servicecatalog.model.primitives.TagOptionId
import scala.jdk.CollectionConverters._
final case class DeleteTagOptionRequest(id: TagOptionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionRequest = {
    import DeleteTagOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionRequest
      .builder()
      .id(TagOptionId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.DeleteTagOptionRequest.ReadOnly =
    zio.aws.servicecatalog.model.DeleteTagOptionRequest.wrap(buildAwsValue())
}
object DeleteTagOptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DeleteTagOptionRequest =
      zio.aws.servicecatalog.model.DeleteTagOptionRequest(id)
    def id: TagOptionId
    def getId: ZIO[Any, Nothing, TagOptionId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionRequest
  ) extends zio.aws.servicecatalog.model.DeleteTagOptionRequest.ReadOnly {
    override val id: TagOptionId =
      zio.aws.servicecatalog.model.primitives.TagOptionId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionRequest
  ): zio.aws.servicecatalog.model.DeleteTagOptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
