package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class DeletePortfolioShareResponse(
    portfolioShareToken: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareResponse = {
    import DeletePortfolioShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareResponse
      .builder()
      .optionallyWith(
        portfolioShareToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.portfolioShareToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DeletePortfolioShareResponse.ReadOnly =
    zio.aws.servicecatalog.model.DeletePortfolioShareResponse
      .wrap(buildAwsValue())
}
object DeletePortfolioShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DeletePortfolioShareResponse =
      zio.aws.servicecatalog.model
        .DeletePortfolioShareResponse(portfolioShareToken.map(value => value))
    def portfolioShareToken: Optional[Id]
    def getPortfolioShareToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("portfolioShareToken", portfolioShareToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareResponse
  ) extends zio.aws.servicecatalog.model.DeletePortfolioShareResponse.ReadOnly {
    override val portfolioShareToken: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.portfolioShareToken())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareResponse
  ): zio.aws.servicecatalog.model.DeletePortfolioShareResponse.ReadOnly =
    new Wrapper(impl)
}
