package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProductViewShortDescription,
  SupportUrl,
  SupportDescription,
  ProductViewName,
  SupportEmail,
  IdempotencyToken,
  ProductViewOwner
}
import scala.jdk.CollectionConverters._
final case class CreateProductRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    name: ProductViewName,
    owner: ProductViewOwner,
    description: Optional[ProductViewShortDescription] = Optional.Absent,
    distributor: Optional[ProductViewOwner] = Optional.Absent,
    supportDescription: Optional[SupportDescription] = Optional.Absent,
    supportEmail: Optional[SupportEmail] = Optional.Absent,
    supportUrl: Optional[SupportUrl] = Optional.Absent,
    productType: zio.aws.servicecatalog.model.ProductType,
    tags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] =
      Optional.Absent,
    provisioningArtifactParameters: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactProperties
    ] = Optional.Absent,
    idempotencyToken: IdempotencyToken,
    sourceConnection: Optional[zio.aws.servicecatalog.model.SourceConnection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest = {
    import CreateProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .name(ProductViewName.unwrap(name): java.lang.String)
      .owner(ProductViewOwner.unwrap(owner): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ProductViewShortDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        distributor.map(value =>
          ProductViewOwner.unwrap(value): java.lang.String
        )
      )(_.distributor)
      .optionallyWith(
        supportDescription.map(value =>
          SupportDescription.unwrap(value): java.lang.String
        )
      )(_.supportDescription)
      .optionallyWith(
        supportEmail.map(value => SupportEmail.unwrap(value): java.lang.String)
      )(_.supportEmail)
      .optionallyWith(
        supportUrl.map(value => SupportUrl.unwrap(value): java.lang.String)
      )(_.supportUrl)
      .productType(productType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        provisioningArtifactParameters.map(value => value.buildAwsValue())
      )(_.provisioningArtifactParameters)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .optionallyWith(sourceConnection.map(value => value.buildAwsValue()))(
        _.sourceConnection
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.CreateProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.CreateProductRequest.wrap(buildAwsValue())
}
object CreateProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreateProductRequest =
      zio.aws.servicecatalog.model.CreateProductRequest(
        acceptLanguage.map(value => value),
        name,
        owner,
        description.map(value => value),
        distributor.map(value => value),
        supportDescription.map(value => value),
        supportEmail.map(value => value),
        supportUrl.map(value => value),
        productType,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisioningArtifactParameters.map(value => value.asEditable),
        idempotencyToken,
        sourceConnection.map(value => value.asEditable)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def name: ProductViewName
    def owner: ProductViewOwner
    def description: Optional[ProductViewShortDescription]
    def distributor: Optional[ProductViewOwner]
    def supportDescription: Optional[SupportDescription]
    def supportEmail: Optional[SupportEmail]
    def supportUrl: Optional[SupportUrl]
    def productType: zio.aws.servicecatalog.model.ProductType
    def tags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def provisioningArtifactParameters: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly
    ]
    def idempotencyToken: IdempotencyToken
    def sourceConnection
        : Optional[zio.aws.servicecatalog.model.SourceConnection.ReadOnly]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getName: ZIO[Any, Nothing, ProductViewName] = ZIO.succeed(name)
    def getOwner: ZIO[Any, Nothing, ProductViewOwner] = ZIO.succeed(owner)
    def getDescription: ZIO[Any, AwsError, ProductViewShortDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDistributor: ZIO[Any, AwsError, ProductViewOwner] =
      AwsError.unwrapOptionField("distributor", distributor)
    def getSupportDescription: ZIO[Any, AwsError, SupportDescription] =
      AwsError.unwrapOptionField("supportDescription", supportDescription)
    def getSupportEmail: ZIO[Any, AwsError, SupportEmail] =
      AwsError.unwrapOptionField("supportEmail", supportEmail)
    def getSupportUrl: ZIO[Any, AwsError, SupportUrl] =
      AwsError.unwrapOptionField("supportUrl", supportUrl)
    def getProductType
        : ZIO[Any, Nothing, zio.aws.servicecatalog.model.ProductType] =
      ZIO.succeed(productType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProvisioningArtifactParameters: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningArtifactParameters",
      provisioningArtifactParameters
    )
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
    def getSourceConnection: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.SourceConnection.ReadOnly
    ] = AwsError.unwrapOptionField("sourceConnection", sourceConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest
  ) extends zio.aws.servicecatalog.model.CreateProductRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val name: ProductViewName =
      zio.aws.servicecatalog.model.primitives.ProductViewName(impl.name())
    override val owner: ProductViewOwner =
      zio.aws.servicecatalog.model.primitives.ProductViewOwner(impl.owner())
    override val description: Optional[ProductViewShortDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProductViewShortDescription(value)
        )
    override val distributor: Optional[ProductViewOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.distributor())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewOwner(value)
      )
    override val supportDescription: Optional[SupportDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportDescription())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.SupportDescription(value)
        )
    override val supportEmail: Optional[SupportEmail] = zio.aws.core.internal
      .optionalFromNullable(impl.supportEmail())
      .map(value => zio.aws.servicecatalog.model.primitives.SupportEmail(value))
    override val supportUrl: Optional[SupportUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.supportUrl())
      .map(value => zio.aws.servicecatalog.model.primitives.SupportUrl(value))
    override val productType: zio.aws.servicecatalog.model.ProductType =
      zio.aws.servicecatalog.model.ProductType.wrap(impl.productType())
    override val tags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val provisioningArtifactParameters: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactParameters())
      .map(value =>
        zio.aws.servicecatalog.model.ProvisioningArtifactProperties.wrap(value)
      )
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
    override val sourceConnection
        : Optional[zio.aws.servicecatalog.model.SourceConnection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceConnection())
        .map(value => zio.aws.servicecatalog.model.SourceConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest
  ): zio.aws.servicecatalog.model.CreateProductRequest.ReadOnly = new Wrapper(
    impl
  )
}
