package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait CopyOption {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.CopyOption
}
object CopyOption {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.CopyOption
  ): zio.aws.servicecatalog.model.CopyOption = value match {
    case software.amazon.awssdk.services.servicecatalog.model.CopyOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.CopyOption.COPY_TAGS =>
      val r = CopyTags
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.CopyOption {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.CopyOption =
      software.amazon.awssdk.services.servicecatalog.model.CopyOption.UNKNOWN_TO_SDK_VERSION
  }
  case object CopyTags extends zio.aws.servicecatalog.model.CopyOption {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.CopyOption =
      software.amazon.awssdk.services.servicecatalog.model.CopyOption.COPY_TAGS
  }
}
