package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.servicecatalog.model.primitives.{
  RepositoryArtifactPath,
  RepositoryBranch,
  Repository,
  CodeStarConnectionArn
}
import scala.jdk.CollectionConverters._
final case class CodeStarParameters(
    connectionArn: CodeStarConnectionArn,
    repository: Repository,
    branch: RepositoryBranch,
    artifactPath: RepositoryArtifactPath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CodeStarParameters = {
    import CodeStarParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CodeStarParameters
      .builder()
      .connectionArn(
        CodeStarConnectionArn.unwrap(connectionArn): java.lang.String
      )
      .repository(Repository.unwrap(repository): java.lang.String)
      .branch(RepositoryBranch.unwrap(branch): java.lang.String)
      .artifactPath(
        RepositoryArtifactPath.unwrap(artifactPath): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.CodeStarParameters.ReadOnly =
    zio.aws.servicecatalog.model.CodeStarParameters.wrap(buildAwsValue())
}
object CodeStarParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CodeStarParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CodeStarParameters =
      zio.aws.servicecatalog.model.CodeStarParameters(
        connectionArn,
        repository,
        branch,
        artifactPath
      )
    def connectionArn: CodeStarConnectionArn
    def repository: Repository
    def branch: RepositoryBranch
    def artifactPath: RepositoryArtifactPath
    def getConnectionArn: ZIO[Any, Nothing, CodeStarConnectionArn] =
      ZIO.succeed(connectionArn)
    def getRepository: ZIO[Any, Nothing, Repository] = ZIO.succeed(repository)
    def getBranch: ZIO[Any, Nothing, RepositoryBranch] = ZIO.succeed(branch)
    def getArtifactPath: ZIO[Any, Nothing, RepositoryArtifactPath] =
      ZIO.succeed(artifactPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CodeStarParameters
  ) extends zio.aws.servicecatalog.model.CodeStarParameters.ReadOnly {
    override val connectionArn: CodeStarConnectionArn =
      zio.aws.servicecatalog.model.primitives
        .CodeStarConnectionArn(impl.connectionArn())
    override val repository: Repository =
      zio.aws.servicecatalog.model.primitives.Repository(impl.repository())
    override val branch: RepositoryBranch =
      zio.aws.servicecatalog.model.primitives.RepositoryBranch(impl.branch())
    override val artifactPath: RepositoryArtifactPath =
      zio.aws.servicecatalog.model.primitives
        .RepositoryArtifactPath(impl.artifactPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CodeStarParameters
  ): zio.aws.servicecatalog.model.CodeStarParameters.ReadOnly = new Wrapper(
    impl
  )
}
