package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ChangeAction {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.ChangeAction
}
object ChangeAction {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ChangeAction
  ): zio.aws.servicecatalog.model.ChangeAction = value match {
    case software.amazon.awssdk.services.servicecatalog.model.ChangeAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.ChangeAction.ADD =>
      val r = ADD
      r
    case software.amazon.awssdk.services.servicecatalog.model.ChangeAction.MODIFY =>
      val r = MODIFY
      r
    case software.amazon.awssdk.services.servicecatalog.model.ChangeAction.REMOVE =>
      val r = REMOVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ChangeAction =
      software.amazon.awssdk.services.servicecatalog.model.ChangeAction.UNKNOWN_TO_SDK_VERSION
  }
  case object ADD extends zio.aws.servicecatalog.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ChangeAction =
      software.amazon.awssdk.services.servicecatalog.model.ChangeAction.ADD
  }
  case object MODIFY extends zio.aws.servicecatalog.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ChangeAction =
      software.amazon.awssdk.services.servicecatalog.model.ChangeAction.MODIFY
  }
  case object REMOVE extends zio.aws.servicecatalog.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ChangeAction =
      software.amazon.awssdk.services.servicecatalog.model.ChangeAction.REMOVE
  }
}
