package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.BudgetName
import scala.jdk.CollectionConverters._
final case class BudgetDetail(
    budgetName: Optional[BudgetName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.BudgetDetail = {
    import BudgetDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.BudgetDetail
      .builder()
      .optionallyWith(
        budgetName.map(value => BudgetName.unwrap(value): java.lang.String)
      )(_.budgetName)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.BudgetDetail.ReadOnly =
    zio.aws.servicecatalog.model.BudgetDetail.wrap(buildAwsValue())
}
object BudgetDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.BudgetDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.BudgetDetail =
      zio.aws.servicecatalog.model.BudgetDetail(budgetName.map(value => value))
    def budgetName: Optional[BudgetName]
    def getBudgetName: ZIO[Any, AwsError, BudgetName] =
      AwsError.unwrapOptionField("budgetName", budgetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.BudgetDetail
  ) extends zio.aws.servicecatalog.model.BudgetDetail.ReadOnly {
    override val budgetName: Optional[BudgetName] = zio.aws.core.internal
      .optionalFromNullable(impl.budgetName())
      .map(value => zio.aws.servicecatalog.model.primitives.BudgetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.BudgetDetail
  ): zio.aws.servicecatalog.model.BudgetDetail.ReadOnly = new Wrapper(impl)
}
