package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SourceConnectionParameters(
    codeStar: Optional[zio.aws.servicecatalog.model.CodeStarParameters] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.SourceConnectionParameters = {
    import SourceConnectionParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.SourceConnectionParameters
      .builder()
      .optionallyWith(codeStar.map(value => value.buildAwsValue()))(_.codeStar)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.SourceConnectionParameters.ReadOnly =
    zio.aws.servicecatalog.model.SourceConnectionParameters
      .wrap(buildAwsValue())
}
object SourceConnectionParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.SourceConnectionParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.SourceConnectionParameters =
      zio.aws.servicecatalog.model
        .SourceConnectionParameters(codeStar.map(value => value.asEditable))
    def codeStar
        : Optional[zio.aws.servicecatalog.model.CodeStarParameters.ReadOnly]
    def getCodeStar: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.CodeStarParameters.ReadOnly
    ] = AwsError.unwrapOptionField("codeStar", codeStar)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.SourceConnectionParameters
  ) extends zio.aws.servicecatalog.model.SourceConnectionParameters.ReadOnly {
    override val codeStar
        : Optional[zio.aws.servicecatalog.model.CodeStarParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeStar())
        .map(value =>
          zio.aws.servicecatalog.model.CodeStarParameters.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.SourceConnectionParameters
  ): zio.aws.servicecatalog.model.SourceConnectionParameters.ReadOnly =
    new Wrapper(impl)
}
