package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait PrincipalType {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.PrincipalType
}
object PrincipalType {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.PrincipalType
  ): zio.aws.servicecatalog.model.PrincipalType = value match {
    case software.amazon.awssdk.services.servicecatalog.model.PrincipalType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.PrincipalType.IAM =>
      val r = IAM
      r
    case software.amazon.awssdk.services.servicecatalog.model.PrincipalType.IAM_PATTERN =>
      val r = IAM_PATTERN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.PrincipalType =
      software.amazon.awssdk.services.servicecatalog.model.PrincipalType.UNKNOWN_TO_SDK_VERSION
  }
  case object IAM extends zio.aws.servicecatalog.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.PrincipalType =
      software.amazon.awssdk.services.servicecatalog.model.PrincipalType.IAM
  }
  case object IAM_PATTERN extends zio.aws.servicecatalog.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.PrincipalType =
      software.amazon.awssdk.services.servicecatalog.model.PrincipalType.IAM_PATTERN
  }
}
