package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListServiceActionsForProvisioningArtifactResponse(
    serviceActionSummaries: Optional[
      Iterable[zio.aws.servicecatalog.model.ServiceActionSummary]
    ] = Optional.Absent,
    nextPageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse = {
    import ListServiceActionsForProvisioningArtifactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse
      .builder()
      .optionallyWith(
        serviceActionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceActionSummaries)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse
      .wrap(buildAwsValue())
}
object ListServiceActionsForProvisioningArtifactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse =
      zio.aws.servicecatalog.model
        .ListServiceActionsForProvisioningArtifactResponse(
          serviceActionSummaries.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextPageToken.map(value => value)
        )
    def serviceActionSummaries: Optional[
      List[zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly]
    ]
    def nextPageToken: Optional[PageToken]
    def getServiceActionSummaries: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serviceActionSummaries",
      serviceActionSummaries
    )
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse
  ) extends zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse.ReadOnly {
    override val serviceActionSummaries: Optional[
      List[zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceActionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ServiceActionSummary.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse
  ): zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse.ReadOnly =
    new Wrapper(impl)
}
