package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListRecordHistoryResponse(
    recordDetails: Optional[
      Iterable[zio.aws.servicecatalog.model.RecordDetail]
    ] = Optional.Absent,
    nextPageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryResponse = {
    import ListRecordHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryResponse
      .builder()
      .optionallyWith(
        recordDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recordDetails)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListRecordHistoryResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListRecordHistoryResponse.wrap(buildAwsValue())
}
object ListRecordHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListRecordHistoryResponse =
      zio.aws.servicecatalog.model.ListRecordHistoryResponse(
        recordDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def recordDetails
        : Optional[List[zio.aws.servicecatalog.model.RecordDetail.ReadOnly]]
    def nextPageToken: Optional[PageToken]
    def getRecordDetails: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.RecordDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("recordDetails", recordDetails)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryResponse
  ) extends zio.aws.servicecatalog.model.ListRecordHistoryResponse.ReadOnly {
    override val recordDetails
        : Optional[List[zio.aws.servicecatalog.model.RecordDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.RecordDetail.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryResponse
  ): zio.aws.servicecatalog.model.ListRecordHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
