package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProvisionedProductName,
  PageToken,
  OutputKey,
  PageSize,
  Id
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetProvisionedProductOutputsRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    provisionedProductId: Optional[Id] = Optional.Absent,
    provisionedProductName: Optional[ProvisionedProductName] = Optional.Absent,
    outputKeys: Optional[Iterable[OutputKey]] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent,
    pageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest = {
    import GetProvisionedProductOutputsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        provisionedProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionedProductId)
      .optionallyWith(
        provisionedProductName.map(value =>
          ProvisionedProductName.unwrap(value): java.lang.String
        )
      )(_.provisionedProductName)
      .optionallyWith(
        outputKeys.map(value =>
          value.map { item =>
            OutputKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.outputKeys)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.GetProvisionedProductOutputsRequest.ReadOnly =
    zio.aws.servicecatalog.model.GetProvisionedProductOutputsRequest
      .wrap(buildAwsValue())
}
object GetProvisionedProductOutputsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.GetProvisionedProductOutputsRequest =
      zio.aws.servicecatalog.model.GetProvisionedProductOutputsRequest(
        acceptLanguage.map(value => value),
        provisionedProductId.map(value => value),
        provisionedProductName.map(value => value),
        outputKeys.map(value => value),
        pageSize.map(value => value),
        pageToken.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def provisionedProductId: Optional[Id]
    def provisionedProductName: Optional[ProvisionedProductName]
    def outputKeys: Optional[List[OutputKey]]
    def pageSize: Optional[PageSize]
    def pageToken: Optional[PageToken]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProvisionedProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionedProductId", provisionedProductId)
    def getProvisionedProductName: ZIO[Any, AwsError, ProvisionedProductName] =
      AwsError.unwrapOptionField(
        "provisionedProductName",
        provisionedProductName
      )
    def getOutputKeys: ZIO[Any, AwsError, List[OutputKey]] =
      AwsError.unwrapOptionField("outputKeys", outputKeys)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest
  ) extends zio.aws.servicecatalog.model.GetProvisionedProductOutputsRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val provisionedProductId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionedProductName: Optional[ProvisionedProductName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedProductName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ProvisionedProductName(value)
        )
    override val outputKeys: Optional[List[OutputKey]] = zio.aws.core.internal
      .optionalFromNullable(impl.outputKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.OutputKey(item)
        }.toList
      )
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest
  ): zio.aws.servicecatalog.model.GetProvisionedProductOutputsRequest.ReadOnly =
    new Wrapper(impl)
}
