package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  ServiceActionDescription,
  ServiceActionName,
  Id
}
import scala.jdk.CollectionConverters._
final case class ServiceActionSummary(
    id: Optional[Id] = Optional.Absent,
    name: Optional[ServiceActionName] = Optional.Absent,
    description: Optional[ServiceActionDescription] = Optional.Absent,
    definitionType: Optional[
      zio.aws.servicecatalog.model.ServiceActionDefinitionType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ServiceActionSummary = {
    import ServiceActionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ServiceActionSummary
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value => ServiceActionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ServiceActionDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(definitionType.map(value => value.unwrap))(
        _.definitionType
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly =
    zio.aws.servicecatalog.model.ServiceActionSummary.wrap(buildAwsValue())
}
object ServiceActionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ServiceActionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ServiceActionSummary =
      zio.aws.servicecatalog.model.ServiceActionSummary(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        definitionType.map(value => value)
      )
    def id: Optional[Id]
    def name: Optional[ServiceActionName]
    def description: Optional[ServiceActionDescription]
    def definitionType
        : Optional[zio.aws.servicecatalog.model.ServiceActionDefinitionType]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ServiceActionName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ServiceActionDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDefinitionType: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ServiceActionDefinitionType
    ] = AwsError.unwrapOptionField("definitionType", definitionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ServiceActionSummary
  ) extends zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val name: Optional[ServiceActionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ServiceActionName(value)
      )
    override val description: Optional[ServiceActionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ServiceActionDescription(value)
        )
    override val definitionType
        : Optional[zio.aws.servicecatalog.model.ServiceActionDefinitionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definitionType())
        .map(value =>
          zio.aws.servicecatalog.model.ServiceActionDefinitionType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ServiceActionSummary
  ): zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly = new Wrapper(
    impl
  )
}
