package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ServiceActionAssociationErrorCode {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode
}
object ServiceActionAssociationErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode
  ): zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode =
    value match {
      case software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.DUPLICATE_RESOURCE =>
        val r = DUPLICATE_RESOURCE
        r
      case software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.INTERNAL_FAILURE =>
        val r = INTERNAL_FAILURE
        r
      case software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.LIMIT_EXCEEDED =>
        val r = LIMIT_EXCEEDED
        r
      case software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.RESOURCE_NOT_FOUND =>
        val r = RESOURCE_NOT_FOUND
        r
      case software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.THROTTLING =>
        val r = THROTTLING
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object DUPLICATE_RESOURCE
      extends zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.DUPLICATE_RESOURCE
  }
  case object INTERNAL_FAILURE
      extends zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.INTERNAL_FAILURE
  }
  case object LIMIT_EXCEEDED
      extends zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.LIMIT_EXCEEDED
  }
  case object RESOURCE_NOT_FOUND
      extends zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.RESOURCE_NOT_FOUND
  }
  case object THROTTLING
      extends zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode.THROTTLING
  }
}
