package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class SearchProductsAsAdminResponse(
    productViewDetails: Optional[
      Iterable[zio.aws.servicecatalog.model.ProductViewDetail]
    ] = Optional.Absent,
    nextPageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse = {
    import SearchProductsAsAdminResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse
      .builder()
      .optionallyWith(
        productViewDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productViewDetails)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.SearchProductsAsAdminResponse.ReadOnly =
    zio.aws.servicecatalog.model.SearchProductsAsAdminResponse
      .wrap(buildAwsValue())
}
object SearchProductsAsAdminResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.SearchProductsAsAdminResponse =
      zio.aws.servicecatalog.model.SearchProductsAsAdminResponse(
        productViewDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def productViewDetails: Optional[
      List[zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly]
    ]
    def nextPageToken: Optional[PageToken]
    def getProductViewDetails: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("productViewDetails", productViewDetails)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse
  ) extends zio.aws.servicecatalog.model.SearchProductsAsAdminResponse.ReadOnly {
    override val productViewDetails: Optional[
      List[zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.productViewDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProductViewDetail.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse
  ): zio.aws.servicecatalog.model.SearchProductsAsAdminResponse.ReadOnly =
    new Wrapper(impl)
}
