package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{CreatedTime, ResourceARN}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProductViewDetail(
    productViewSummary: Optional[
      zio.aws.servicecatalog.model.ProductViewSummary
    ] = Optional.Absent,
    status: Optional[zio.aws.servicecatalog.model.Status] = Optional.Absent,
    productARN: Optional[ResourceARN] = Optional.Absent,
    createdTime: Optional[CreatedTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail = {
    import ProductViewDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail
      .builder()
      .optionallyWith(productViewSummary.map(value => value.buildAwsValue()))(
        _.productViewSummary
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        productARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.productARN)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly =
    zio.aws.servicecatalog.model.ProductViewDetail.wrap(buildAwsValue())
}
object ProductViewDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProductViewDetail =
      zio.aws.servicecatalog.model.ProductViewDetail(
        productViewSummary.map(value => value.asEditable),
        status.map(value => value),
        productARN.map(value => value),
        createdTime.map(value => value)
      )
    def productViewSummary
        : Optional[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly]
    def status: Optional[zio.aws.servicecatalog.model.Status]
    def productARN: Optional[ResourceARN]
    def createdTime: Optional[CreatedTime]
    def getProductViewSummary: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly
    ] = AwsError.unwrapOptionField("productViewSummary", productViewSummary)
    def getStatus: ZIO[Any, AwsError, zio.aws.servicecatalog.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getProductARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("productARN", productARN)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail
  ) extends zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly {
    override val productViewSummary
        : Optional[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productViewSummary())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewSummary.wrap(value)
        )
    override val status: Optional[zio.aws.servicecatalog.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.servicecatalog.model.Status.wrap(value))
    override val productARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.productARN())
      .map(value => zio.aws.servicecatalog.model.primitives.ResourceARN(value))
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreatedTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail
  ): zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly = new Wrapper(impl)
}
