package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{PortfolioName, Id}
import scala.jdk.CollectionConverters._
final case class LaunchPath(
    id: Optional[Id] = Optional.Absent,
    name: Optional[PortfolioName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.LaunchPath = {
    import LaunchPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.LaunchPath
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value => PortfolioName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.LaunchPath.ReadOnly =
    zio.aws.servicecatalog.model.LaunchPath.wrap(buildAwsValue())
}
object LaunchPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.LaunchPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.LaunchPath =
      zio.aws.servicecatalog.model
        .LaunchPath(id.map(value => value), name.map(value => value))
    def id: Optional[Id]
    def name: Optional[PortfolioName]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, PortfolioName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.LaunchPath
  ) extends zio.aws.servicecatalog.model.LaunchPath.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val name: Optional[PortfolioName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PortfolioName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.LaunchPath
  ): zio.aws.servicecatalog.model.LaunchPath.ReadOnly = new Wrapper(impl)
}
