package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeProductAsAdminResponse(
    productViewDetail: Optional[
      zio.aws.servicecatalog.model.ProductViewDetail
    ] = Optional.Absent,
    provisioningArtifactSummaries: Optional[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifactSummary]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] =
      Optional.Absent,
    tagOptions: Optional[
      Iterable[zio.aws.servicecatalog.model.TagOptionDetail]
    ] = Optional.Absent,
    budgets: Optional[Iterable[zio.aws.servicecatalog.model.BudgetDetail]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse = {
    import DescribeProductAsAdminResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse
      .builder()
      .optionallyWith(productViewDetail.map(value => value.buildAwsValue()))(
        _.productViewDetail
      )
      .optionallyWith(
        provisioningArtifactSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifactSummaries)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        tagOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagOptions)
      .optionallyWith(
        budgets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.budgets)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProductAsAdminResponse
      .wrap(buildAwsValue())
}
object DescribeProductAsAdminResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProductAsAdminResponse =
      zio.aws.servicecatalog.model.DescribeProductAsAdminResponse(
        productViewDetail.map(value => value.asEditable),
        provisioningArtifactSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        budgets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def productViewDetail
        : Optional[zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly]
    def provisioningArtifactSummaries: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactSummary.ReadOnly]
    ]
    def tags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def tagOptions
        : Optional[List[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]]
    def budgets
        : Optional[List[zio.aws.servicecatalog.model.BudgetDetail.ReadOnly]]
    def getProductViewDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly
    ] = AwsError.unwrapOptionField("productViewDetail", productViewDetail)
    def getProvisioningArtifactSummaries: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifactSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningArtifactSummaries",
      provisioningArtifactSummaries
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTagOptions: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("tagOptions", tagOptions)
    def getBudgets: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.BudgetDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("budgets", budgets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse
  ) extends zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.ReadOnly {
    override val productViewDetail
        : Optional[zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productViewDetail())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewDetail.wrap(value)
        )
    override val provisioningArtifactSummaries: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifactSummary.wrap(item)
        }.toList
      )
    override val tags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val tagOptions: Optional[
      List[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tagOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.TagOptionDetail.wrap(item)
        }.toList
      )
    override val budgets
        : Optional[List[zio.aws.servicecatalog.model.BudgetDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.budgets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.BudgetDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse
  ): zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.ReadOnly =
    new Wrapper(impl)
}
