package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{OrganizationNodeValue, Id}
import scala.jdk.CollectionConverters._
final case class DescribePortfolioShareStatusResponse(
    portfolioShareToken: Optional[Id] = Optional.Absent,
    portfolioId: Optional[Id] = Optional.Absent,
    organizationNodeValue: Optional[OrganizationNodeValue] = Optional.Absent,
    status: Optional[zio.aws.servicecatalog.model.ShareStatus] =
      Optional.Absent,
    shareDetails: Optional[zio.aws.servicecatalog.model.ShareDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse = {
    import DescribePortfolioShareStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse
      .builder()
      .optionallyWith(
        portfolioShareToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.portfolioShareToken)
      .optionallyWith(
        portfolioId.map(value => Id.unwrap(value): java.lang.String)
      )(_.portfolioId)
      .optionallyWith(
        organizationNodeValue.map(value =>
          OrganizationNodeValue.unwrap(value): java.lang.String
        )
      )(_.organizationNodeValue)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(shareDetails.map(value => value.buildAwsValue()))(
        _.shareDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse
      .wrap(buildAwsValue())
}
object DescribePortfolioShareStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse =
      zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse(
        portfolioShareToken.map(value => value),
        portfolioId.map(value => value),
        organizationNodeValue.map(value => value),
        status.map(value => value),
        shareDetails.map(value => value.asEditable)
      )
    def portfolioShareToken: Optional[Id]
    def portfolioId: Optional[Id]
    def organizationNodeValue: Optional[OrganizationNodeValue]
    def status: Optional[zio.aws.servicecatalog.model.ShareStatus]
    def shareDetails
        : Optional[zio.aws.servicecatalog.model.ShareDetails.ReadOnly]
    def getPortfolioShareToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("portfolioShareToken", portfolioShareToken)
    def getPortfolioId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("portfolioId", portfolioId)
    def getOrganizationNodeValue: ZIO[Any, AwsError, OrganizationNodeValue] =
      AwsError.unwrapOptionField("organizationNodeValue", organizationNodeValue)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.ShareStatus] =
      AwsError.unwrapOptionField("status", status)
    def getShareDetails: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ShareDetails.ReadOnly
    ] = AwsError.unwrapOptionField("shareDetails", shareDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse
  ) extends zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.ReadOnly {
    override val portfolioShareToken: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.portfolioShareToken())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val portfolioId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.portfolioId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val organizationNodeValue: Optional[OrganizationNodeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationNodeValue())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.OrganizationNodeValue(value)
        )
    override val status: Optional[zio.aws.servicecatalog.model.ShareStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.servicecatalog.model.ShareStatus.wrap(value))
    override val shareDetails
        : Optional[zio.aws.servicecatalog.model.ShareDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shareDetails())
        .map(value => zio.aws.servicecatalog.model.ShareDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse
  ): zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.ReadOnly =
    new Wrapper(impl)
}
