package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.servicecatalog.model.primitives.{Id, BudgetName}
import scala.jdk.CollectionConverters._
final case class AssociateBudgetWithResourceRequest(
    budgetName: BudgetName,
    resourceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceRequest = {
    import AssociateBudgetWithResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceRequest
      .builder()
      .budgetName(BudgetName.unwrap(budgetName): java.lang.String)
      .resourceId(Id.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.AssociateBudgetWithResourceRequest.ReadOnly =
    zio.aws.servicecatalog.model.AssociateBudgetWithResourceRequest
      .wrap(buildAwsValue())
}
object AssociateBudgetWithResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.AssociateBudgetWithResourceRequest =
      zio.aws.servicecatalog.model
        .AssociateBudgetWithResourceRequest(budgetName, resourceId)
    def budgetName: BudgetName
    def resourceId: Id
    def getBudgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetName)
    def getResourceId: ZIO[Any, Nothing, Id] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceRequest
  ) extends zio.aws.servicecatalog.model.AssociateBudgetWithResourceRequest.ReadOnly {
    override val budgetName: BudgetName =
      zio.aws.servicecatalog.model.primitives.BudgetName(impl.budgetName())
    override val resourceId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceRequest
  ): zio.aws.servicecatalog.model.AssociateBudgetWithResourceRequest.ReadOnly =
    new Wrapper(impl)
}
