package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  ConstraintParameters,
  ConstraintDescription,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class UpdateConstraintRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    id: Id,
    description: Optional[ConstraintDescription] = Optional.Absent,
    parameters: Optional[ConstraintParameters] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest = {
    import UpdateConstraintRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ConstraintDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        parameters.map(value =>
          ConstraintParameters.unwrap(value): java.lang.String
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdateConstraintRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdateConstraintRequest.wrap(buildAwsValue())
}
object UpdateConstraintRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdateConstraintRequest =
      zio.aws.servicecatalog.model.UpdateConstraintRequest(
        acceptLanguage.map(value => value),
        id,
        description.map(value => value),
        parameters.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def id: Id
    def description: Optional[ConstraintDescription]
    def parameters: Optional[ConstraintParameters]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getDescription: ZIO[Any, AwsError, ConstraintDescription] =
      AwsError.unwrapOptionField("description", description)
    def getParameters: ZIO[Any, AwsError, ConstraintParameters] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest
  ) extends zio.aws.servicecatalog.model.UpdateConstraintRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
    override val description: Optional[ConstraintDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ConstraintDescription(value)
        )
    override val parameters: Optional[ConstraintParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ConstraintParameters(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest
  ): zio.aws.servicecatalog.model.UpdateConstraintRequest.ReadOnly =
    new Wrapper(impl)
}
