package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.Status
  ): zio.aws.servicecatalog.model.Status = value match {
    case software.amazon.awssdk.services.servicecatalog.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.Status.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.servicecatalog.model.Status.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.servicecatalog.model.Status.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.servicecatalog.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.Status =
      software.amazon.awssdk.services.servicecatalog.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.servicecatalog.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.Status =
      software.amazon.awssdk.services.servicecatalog.model.Status.AVAILABLE
  }
  case object CREATING extends zio.aws.servicecatalog.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.Status =
      software.amazon.awssdk.services.servicecatalog.model.Status.CREATING
  }
  case object FAILED extends zio.aws.servicecatalog.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.Status =
      software.amazon.awssdk.services.servicecatalog.model.Status.FAILED
  }
}
