package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ScanProvisionedProductsResponse(
    provisionedProducts: Optional[
      Iterable[zio.aws.servicecatalog.model.ProvisionedProductDetail]
    ] = Optional.Absent,
    nextPageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsResponse = {
    import ScanProvisionedProductsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsResponse
      .builder()
      .optionallyWith(
        provisionedProducts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedProducts)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ScanProvisionedProductsResponse.ReadOnly =
    zio.aws.servicecatalog.model.ScanProvisionedProductsResponse
      .wrap(buildAwsValue())
}
object ScanProvisionedProductsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ScanProvisionedProductsResponse =
      zio.aws.servicecatalog.model.ScanProvisionedProductsResponse(
        provisionedProducts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def provisionedProducts: Optional[
      List[zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly]
    ]
    def nextPageToken: Optional[PageToken]
    def getProvisionedProducts: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("provisionedProducts", provisionedProducts)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsResponse
  ) extends zio.aws.servicecatalog.model.ScanProvisionedProductsResponse.ReadOnly {
    override val provisionedProducts: Optional[
      List[zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedProducts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisionedProductDetail.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsResponse
  ): zio.aws.servicecatalog.model.ScanProvisionedProductsResponse.ReadOnly =
    new Wrapper(impl)
}
