package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait EvaluationType {
  def unwrap
      : software.amazon.awssdk.services.servicecatalog.model.EvaluationType
}
object EvaluationType {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.EvaluationType
  ): zio.aws.servicecatalog.model.EvaluationType = value match {
    case software.amazon.awssdk.services.servicecatalog.model.EvaluationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.EvaluationType.STATIC =>
      val r = STATIC
      r
    case software.amazon.awssdk.services.servicecatalog.model.EvaluationType.DYNAMIC =>
      val r = DYNAMIC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.EvaluationType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.EvaluationType =
      software.amazon.awssdk.services.servicecatalog.model.EvaluationType.UNKNOWN_TO_SDK_VERSION
  }
  case object STATIC extends zio.aws.servicecatalog.model.EvaluationType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.EvaluationType =
      software.amazon.awssdk.services.servicecatalog.model.EvaluationType.STATIC
  }
  case object DYNAMIC extends zio.aws.servicecatalog.model.EvaluationType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.EvaluationType =
      software.amazon.awssdk.services.servicecatalog.model.EvaluationType.DYNAMIC
  }
}
