package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.servicecatalog.model.primitives.{TagOptionValue, TagOptionKey}
import scala.jdk.CollectionConverters._
final case class CreateTagOptionRequest(
    key: TagOptionKey,
    value: TagOptionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionRequest = {
    import CreateTagOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionRequest
      .builder()
      .key(TagOptionKey.unwrap(key): java.lang.String)
      .value(TagOptionValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.CreateTagOptionRequest.ReadOnly =
    zio.aws.servicecatalog.model.CreateTagOptionRequest.wrap(buildAwsValue())
}
object CreateTagOptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreateTagOptionRequest =
      zio.aws.servicecatalog.model.CreateTagOptionRequest(key, value)
    def key: TagOptionKey
    def value: TagOptionValue
    def getKey: ZIO[Any, Nothing, TagOptionKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagOptionValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionRequest
  ) extends zio.aws.servicecatalog.model.CreateTagOptionRequest.ReadOnly {
    override val key: TagOptionKey =
      zio.aws.servicecatalog.model.primitives.TagOptionKey(impl.key())
    override val value: TagOptionValue =
      zio.aws.servicecatalog.model.primitives.TagOptionValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionRequest
  ): zio.aws.servicecatalog.model.CreateTagOptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
