package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ShareStatus {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.ShareStatus
}
object ShareStatus {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ShareStatus
  ): zio.aws.servicecatalog.model.ShareStatus = value match {
    case software.amazon.awssdk.services.servicecatalog.model.ShareStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.ShareStatus.NOT_STARTED =>
      val r = NOT_STARTED
      r
    case software.amazon.awssdk.services.servicecatalog.model.ShareStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.servicecatalog.model.ShareStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.servicecatalog.model.ShareStatus.COMPLETED_WITH_ERRORS =>
      val r = COMPLETED_WITH_ERRORS
      r
    case software.amazon.awssdk.services.servicecatalog.model.ShareStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ShareStatus =
      software.amazon.awssdk.services.servicecatalog.model.ShareStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_STARTED extends zio.aws.servicecatalog.model.ShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ShareStatus =
      software.amazon.awssdk.services.servicecatalog.model.ShareStatus.NOT_STARTED
  }
  case object IN_PROGRESS extends zio.aws.servicecatalog.model.ShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ShareStatus =
      software.amazon.awssdk.services.servicecatalog.model.ShareStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.servicecatalog.model.ShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ShareStatus =
      software.amazon.awssdk.services.servicecatalog.model.ShareStatus.COMPLETED
  }
  case object COMPLETED_WITH_ERRORS
      extends zio.aws.servicecatalog.model.ShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ShareStatus =
      software.amazon.awssdk.services.servicecatalog.model.ShareStatus.COMPLETED_WITH_ERRORS
  }
  case object ERROR extends zio.aws.servicecatalog.model.ShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ShareStatus =
      software.amazon.awssdk.services.servicecatalog.model.ShareStatus.ERROR
  }
}
