package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{PageToken, PageSize}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTagOptionsRequest(
    filters: Optional[zio.aws.servicecatalog.model.ListTagOptionsFilters] =
      Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent,
    pageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest = {
    import ListTagOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ListTagOptionsRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListTagOptionsRequest.wrap(buildAwsValue())
}
object ListTagOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListTagOptionsRequest =
      zio.aws.servicecatalog.model.ListTagOptionsRequest(
        filters.map(value => value.asEditable),
        pageSize.map(value => value),
        pageToken.map(value => value)
      )
    def filters
        : Optional[zio.aws.servicecatalog.model.ListTagOptionsFilters.ReadOnly]
    def pageSize: Optional[PageSize]
    def pageToken: Optional[PageToken]
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ListTagOptionsFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest
  ) extends zio.aws.servicecatalog.model.ListTagOptionsRequest.ReadOnly {
    override val filters: Optional[
      zio.aws.servicecatalog.model.ListTagOptionsFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.servicecatalog.model.ListTagOptionsFilters.wrap(value)
      )
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest
  ): zio.aws.servicecatalog.model.ListTagOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
