package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListConstraintsForPortfolioResponse(
    constraintDetails: Optional[
      Iterable[zio.aws.servicecatalog.model.ConstraintDetail]
    ] = Optional.Absent,
    nextPageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse = {
    import ListConstraintsForPortfolioResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse
      .builder()
      .optionallyWith(
        constraintDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.constraintDetails)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse
      .wrap(buildAwsValue())
}
object ListConstraintsForPortfolioResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse =
      zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse(
        constraintDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def constraintDetails
        : Optional[List[zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly]]
    def nextPageToken: Optional[PageToken]
    def getConstraintDetails: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("constraintDetails", constraintDetails)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse
  ) extends zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse.ReadOnly {
    override val constraintDetails: Optional[
      List[zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.constraintDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ConstraintDetail.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse
  ): zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse.ReadOnly =
    new Wrapper(impl)
}
