package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class CreatePortfolioShareResponse(
    portfolioShareToken: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareResponse = {
    import CreatePortfolioShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareResponse
      .builder()
      .optionallyWith(
        portfolioShareToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.portfolioShareToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreatePortfolioShareResponse.ReadOnly =
    zio.aws.servicecatalog.model.CreatePortfolioShareResponse
      .wrap(buildAwsValue())
}
object CreatePortfolioShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreatePortfolioShareResponse =
      zio.aws.servicecatalog.model
        .CreatePortfolioShareResponse(portfolioShareToken.map(value => value))
    def portfolioShareToken: Optional[Id]
    def getPortfolioShareToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("portfolioShareToken", portfolioShareToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareResponse
  ) extends zio.aws.servicecatalog.model.CreatePortfolioShareResponse.ReadOnly {
    override val portfolioShareToken: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.portfolioShareToken())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareResponse
  ): zio.aws.servicecatalog.model.CreatePortfolioShareResponse.ReadOnly =
    new Wrapper(impl)
}
